/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.oidc.security.impl.BaseJWTSignatureSecurityHandler;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class JWTMessageSignatureSecurityHandler
extends BaseJWTSignatureSecurityHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWTMessageSignatureSecurityHandler.class);
    @NonnullAfterInit
    private Function<MessageContext, SignedJWT> jwtTokenLookupStrategy;
    @NonnullBeforeExec
    private SignedJWT signedJwt;

    public void setJwtTokenLookupStrategy(@Nonnull Function<MessageContext, SignedJWT> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.jwtTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JwtToken lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.jwtTokenLookupStrategy == null) {
            throw new ComponentInitializationException("JwtTokenLookupStrategy cannot be null");
        }
    }

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.signedJwt = this.jwtTokenLookupStrategy.apply(messageContext);
        if (this.signedJwt == null) {
            this.log.debug("{} Extracted JWT was not a SignedJWT, cannot process signature", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Signed JWT was missing or unpopulated");
        }
        try {
            this.signedJwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new MessageHandlerException("Signed JWT did not have any claims, signature check failed");
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        OIDCPeerEntityContext peerContext;
        if (this.signedJwt.getState() != JWSObject.State.SIGNED && this.signedJwt.getState() != JWSObject.State.VERIFIED) {
            this.log.debug("{} The JWS object must be in a signed or verified state, cannot process signature", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Validation of JWS failed. JWT is not signed.");
        }
        if (this.signedJwt.getState() == JWSObject.State.VERIFIED) {
            this.log.debug("{} The JWS object was already verified! validating again", (Object)this.getLogPrefix());
        }
        String issuerId = (peerContext = this.getOIDCPeerEntityContext()) != null ? peerContext.getIdentifier() : null;
        SignedJWT localSignedJwt = this.signedJwt;
        assert (localSignedJwt != null);
        if (!this.evaluate(localSignedJwt, issuerId, messageContext)) {
            this.log.debug("{} Validation of JWS token signature failed for context issuer '{}'", (Object)this.getLogPrefix(), (Object)issuerId);
            throw new MessageHandlerException("Validation of JWS failed");
        }
        this.log.debug("{} Validation of JWS token signature succeeded for peer '{}'", (Object)this.getLogPrefix(), (Object)issuerId);
    }
}

