/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.jose.SignatureException;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class JWSTokenSigner {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWSTokenSigner.class);
    @Nonnull
    private final SignatureSigningParameters params;

    public JWSTokenSigner(@Nonnull SignatureSigningParameters signingParams) {
        this.params = (SignatureSigningParameters)Constraint.isNotNull((Object)signingParams, (String)"Signing params can not be null");
    }

    @Nonnull
    public SignedJWT sign(@Nonnull JWTClaimsSet jwtClaims, @Nullable String typeHeader) throws SignatureException {
        try {
            Credential credential = this.params.getSigningCredential();
            String algorithm = this.params.getSignatureAlgorithm();
            if (credential == null) {
                throw new SignatureException("Signature signinig credential is not available");
            }
            if (algorithm == null) {
                throw new SignatureException("Signature signinig algorithm is not available");
            }
            JWSAlgorithm jwsAlgorithm = this.resolveAlgorithm(credential, algorithm);
            JWSSigner signer = this.getSigner((Algorithm)jwsAlgorithm, credential);
            JWSHeader.Builder headerBuilder = new JWSHeader.Builder(new JWSAlgorithm(jwsAlgorithm.getName())).keyID(CredentialConversionUtil.resolveKid((Credential)credential));
            if (typeHeader != null) {
                headerBuilder.type(new JOSEObjectType(typeHeader));
            }
            SignedJWT jwt = new SignedJWT(headerBuilder.build(), jwtClaims);
            jwt.sign(signer);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Signed JWT using kid '{}'", (Object)CredentialConversionUtil.resolveKid((Credential)credential));
            }
            if (jwt.getState() != JWSObject.State.SIGNED) {
                throw new SignatureException("JWT was not signed, unknown cause");
            }
            return jwt;
        }
        catch (JOSEException e) {
            throw new SignatureException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Nonnull
    protected JWSSigner getSigner(@Nonnull Algorithm jwsAlgorithm, @Nonnull Credential credential) throws JOSEException {
        PrivateKey key;
        PrivateKey privateKey;
        if (JWSAlgorithm.Family.EC.contains((Object)jwsAlgorithm) && (privateKey = credential.getPrivateKey()) instanceof ECPrivateKey) {
            ECPrivateKey ecKey = (ECPrivateKey)privateKey;
            return new ECDSASigner(ecKey);
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm) && (key = credential.getPrivateKey()) != null && "RSA".equals(key.getAlgorithm())) {
            return new RSASSASigner(credential.getPrivateKey());
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm) && credential.getSecretKey() != null) {
            return new MACSigner(credential.getSecretKey());
        }
        throw new JOSEException("Unsupported algorithm " + jwsAlgorithm.getName() + " for key '" + CredentialConversionUtil.resolveKid((Credential)credential) + "'");
    }

    @Nonnull
    protected JWSAlgorithm resolveAlgorithm(@Nonnull Credential credential, @Nonnull String algorithmString) {
        JWKCredential jwkCred;
        JWSAlgorithm algorithm = new JWSAlgorithm(algorithmString);
        if (credential instanceof JWKCredential && !algorithm.equals((Object)(jwkCred = (JWKCredential)credential).getAlgorithm())) {
            this.log.debug("Signature signing algorithm {} differs from JWK algorithm '{}'", (Object)algorithm.getName(), jwkCred.getAlgorithm() != null ? jwkCred.getAlgorithm() : "not specified");
        }
        this.log.trace("Algorithm resolved {}", (Object)algorithm.getName());
        return algorithm;
    }
}

