/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.google.common.base.Strings;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.SignedJWT;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.credential.impl.EvaluableKeyIDCredentialCriterion;
import net.shibboleth.oidc.security.credential.impl.EvaluableMACKeyLengthCredentialCriterion;
import net.shibboleth.oidc.security.impl.BaseSignedJWTTrustEngine;
import net.shibboleth.oidc.security.impl.ExplicitKeyTrustEvaluator;
import net.shibboleth.oidc.security.jose.criterion.KeyIdCriterion;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;

public class ExplicitKeySignedJWTTrustEngine
extends BaseSignedJWTTrustEngine<Iterable<Credential>>
implements TrustedCredentialTrustEngine<SignedJWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExplicitKeySignedJWTTrustEngine.class);
    @Nonnull
    private final CredentialResolver credentialResolver;
    private final ExplicitKeyTrustEvaluator keyTrust;

    public ExplicitKeySignedJWTTrustEngine(@Nonnull @ParameterName(name="resolver") CredentialResolver resolver, @Nonnull @ParameterName(name="JOSEObjectResolver") JOSEObjectCredentialResolver joseObjectResolver) {
        super(joseObjectResolver);
        this.credentialResolver = (CredentialResolver)Constraint.isNotNull((Object)resolver, (String)"Credential resolver cannot be null");
        this.keyTrust = new ExplicitKeyTrustEvaluator();
    }

    @Nonnull
    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    protected boolean doValidate(@Nonnull SignedJWT signedJWT, @Nonnull CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable trustedCredentials;
        String kid;
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.addAll((Collection)trustBasisCriteria);
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        JWSAlgorithm sigAlg = signedJWT.getHeader().getAlgorithm();
        String sigAlgName = sigAlg.getName();
        assert (sigAlgName != null);
        String jcaAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)sigAlgName);
        if (!Strings.isNullOrEmpty((String)jcaAlgorithm)) {
            assert (jcaAlgorithm != null);
            criteriaSet.add((Object)new KeyAlgorithmCriterion(jcaAlgorithm), true);
        }
        if (!Strings.isNullOrEmpty((String)(kid = signedJWT.getHeader().getKeyID()))) {
            assert (kid != null);
            criteriaSet.add((Object)new EvaluableKeyIDCredentialCriterion(new KeyIdCriterion(kid)));
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)sigAlg)) {
            criteriaSet.add((Object)new EvaluableMACKeyLengthCredentialCriterion(sigAlg));
        }
        try {
            trustedCredentials = this.getCredentialResolver().resolve((Object)criteriaSet);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted credentials", (Exception)((Object)e));
        }
        if (this.validate(signedJWT, trustedCredentials)) {
            return true;
        }
        this.log.debug("Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            assert (trustedCredential != null);
            if (!this.verifySignature(signedJWT, trustedCredential)) continue;
            this.log.debug("Successfully verified signature using resolved trusted credential");
            return true;
        }
        this.log.debug("Failed to verify signature using either token-derived or directly trusted credentials");
        return false;
    }

    @Override
    protected boolean evaluateTrust(@Nonnull Credential untrustedCredential, @Nullable Iterable<Credential> trustedCredentials) throws SecurityException {
        if (trustedCredentials != null) {
            return this.keyTrust.validate(untrustedCredential, trustedCredentials);
        }
        return false;
    }
}

