/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import java.text.ParseException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.security.impl.JWETokenDecrypter;
import net.shibboleth.oidc.security.jose.DecryptionParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.slf4j.Logger;

public class DecryptJWE
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DecryptJWE.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, EncryptedJWT> jwtTokenLookupStrategy;
    @NonnullAfterInit
    private BiConsumer<ProfileRequestContext, JWT> jwtUpdateStrategy;
    @Nonnull
    private String errorEventId = "InvalidToken";
    @NonnullBeforeExec
    private EncryptedJWT encryptedJwt;
    @NonnullBeforeExec
    private JWETokenDecrypter decrypter;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParamsLookupStrategy = new ChildContextLookup(SecurityParametersContext.class).compose((Function)new InboundMessageContextLookup());

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParamsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setJwtUpdateStrategy(@Nonnull BiConsumer<ProfileRequestContext, JWT> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.jwtUpdateStrategy = (BiConsumer)Constraint.isNotNull(strategy, (String)"JWT update stategy can not be null");
    }

    public void setJwtTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptedJWT> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.jwtTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JwtToken lookup strategy cannot be null");
    }

    public void setErrorEventId(@Nonnull String id) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.errorEventId = Constraint.isNotEmpty((String)id, (String)"Error event identifier cannot be empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.jwtTokenLookupStrategy == null) {
            throw new ComponentInitializationException("JWTTokenLookupStrategy cannot be null");
        }
        if (this.jwtUpdateStrategy == null) {
            throw new ComponentInitializationException("JWTUpdateStrategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        DecryptionParameters params;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.encryptedJwt = this.jwtTokenLookupStrategy.apply(profileRequestContext);
        if (this.encryptedJwt == null) {
            this.log.debug("{} JWT was not encrypted, nothing to decrypt", (Object)this.getLogPrefix());
            return false;
        }
        SecurityParametersContext paramsCtx = this.securityParamsLookupStrategy.apply(profileRequestContext);
        DecryptionParameters decryptionParameters = params = paramsCtx != null ? paramsCtx.getDecryptionParameters() : null;
        if (params == null) {
            this.log.debug("{} No security parameter context or decryption parameters", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.decrypter = new JWETokenDecrypter(params);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Decrypting encrypted JWT", (Object)this.getLogPrefix());
        try {
            JWT decryptedJWT = this.decrypter.decrypt(this.encryptedJwt);
            this.log.debug("{} JWT decrypted successfully", (Object)this.getLogPrefix());
            if (this.log.isTraceEnabled()) {
                this.logJWT(decryptedJWT);
            }
            this.jwtUpdateStrategy.accept(profileRequestContext, decryptedJWT);
        }
        catch (DecryptionException e) {
            this.log.error("{} Unable to decrypt JWT", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.errorEventId);
            return;
        }
    }

    private void logJWT(@Nonnull JWT jwt) {
        try {
            this.log.trace("{} Decrypted JWT: {}", (Object)this.getLogPrefix(), (Object)jwt.getJWTClaimsSet());
        }
        catch (IllegalStateException | ParseException e) {
            this.log.trace("{} Unable to print decrypted JWT: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
        }
    }
}

