/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class CheckClientJWTSignatureAlgorithmHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckClientJWTSignatureAlgorithmHandler.class);
    @NonnullAfterInit
    private Function<MessageContext, SignedJWT> jwtTokenLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, OIDCClientInformation> clientInformationLookupStrategy;
    @NonnullAfterInit
    private Function<OIDCClientInformation, String> signatureAlgorithmLookupStrategy;
    @NonnullBeforeExec
    private SignedJWT signedJwt;
    @Nullable
    private String defaultAlgorithmValue;

    public void setJwtTokenLookupStrategy(@Nonnull Function<MessageContext, SignedJWT> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.jwtTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JwtToken lookup strategy cannot be null");
    }

    public void setClientInformationLookupStrategy(@Nonnull Function<MessageContext, OIDCClientInformation> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientInformationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client information lookup strategy can not be null");
    }

    public void setSignatureAlgorithmLookupStrategy(@Nonnull Function<OIDCClientInformation, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.signatureAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Signature algorithm lookup strategy cannot be null");
    }

    public void setDefaultAlgorithmValue(@Nullable String value) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.defaultAlgorithmValue = StringSupport.trimOrNull((String)value);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.jwtTokenLookupStrategy == null) {
            throw new ComponentInitializationException("JwtTokenLookupStrategy cannot be null");
        }
        if (this.signatureAlgorithmLookupStrategy == null) {
            throw new ComponentInitializationException("SignatureAlgorithmLookupStrategy cannot be null");
        }
        if (this.clientInformationLookupStrategy == null) {
            throw new ComponentInitializationException("ClientInformationLookupStrategy cannot be null");
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.signedJwt = this.jwtTokenLookupStrategy.apply(messageContext);
        if (this.signedJwt == null) {
            this.log.debug("{} Extracted JWT was not a SignedJWT, cannot process signature", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Signed JWT was missing or unpopulated");
        }
        return true;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String tokenAlgorithm = this.signedJwt.getHeader().getAlgorithm().getName();
        String expectedAlgorithm = this.getExpectedAlgorithm(this.clientInformationLookupStrategy.apply(messageContext));
        if (expectedAlgorithm == null) {
            this.log.debug("No expected algorithm defined, accepting {} from the token", (Object)tokenAlgorithm);
            return;
        }
        if (tokenAlgorithm.equals(expectedAlgorithm)) {
            this.log.debug("The algorithnm specified in the token was expected {}", (Object)tokenAlgorithm);
            return;
        }
        this.log.warn("The algorithnm specified in the token {} was not expected {}", (Object)tokenAlgorithm, (Object)expectedAlgorithm);
        throw new MessageHandlerException("Validation of JWS failed. The algorithm " + tokenAlgorithm + " was not the expected " + expectedAlgorithm);
    }

    @Nullable
    protected String getExpectedAlgorithm(@Nullable OIDCClientInformation clientInformation) {
        if (clientInformation != null) {
            String storedAlgorithm = this.signatureAlgorithmLookupStrategy.apply(clientInformation);
            if (StringSupport.trimOrNull((String)storedAlgorithm) == null) {
                this.log.debug("No algorithm value specified in metadata, using default value {}", (Object)this.defaultAlgorithmValue);
                return this.defaultAlgorithmValue;
            }
            this.log.debug("Found the expected algorithm from metadata: {}", (Object)storedAlgorithm);
            return storedAlgorithm;
        }
        this.log.debug("No client information found, using default value {}", (Object)this.defaultAlgorithmValue);
        return this.defaultAlgorithmValue;
    }
}

