/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CheckClientJWTDecryptionConfiguration
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckClientJWTDecryptionConfiguration.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, JWT> jwtTokenLookupStrategy;
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate;
    @NonnullAfterInit
    private Function<ProfileRequestContext, OIDCClientInformation> clientInformationLookupStrategy;
    @NonnullAfterInit
    private Function<OIDCClientInformation, String> dataEncryptionAlgorithmLookupStrategy;
    @NonnullAfterInit
    private Function<OIDCClientInformation, String> keyTransportEncryptionAlgorithmLookupStrategy;
    @NonnullAfterInit
    private String errorEventId;
    @NonnullBeforeExec
    private EncryptedJWT encryptedJwt;
    private boolean encryptionOptional;

    public void setJwtTokenLookupStrategy(@Nonnull Function<ProfileRequestContext, JWT> strategy) {
        this.checkSetterPreconditions();
        this.jwtTokenLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JwtToken lookup strategy cannot be null");
    }

    public void setClientInformationLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientInformation> strategy) {
        this.checkSetterPreconditions();
        this.clientInformationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client information lookup strategy can not be null");
    }

    public void setDataEncryptionAlgorithmLookupStrategy(@Nonnull Function<OIDCClientInformation, String> strategy) {
        this.checkSetterPreconditions();
        this.dataEncryptionAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Data encryption algorithm lookup strategy cannot be null");
    }

    public void setKeyTransportEncryptionAlgorithmLookupStrategy(@Nonnull Function<OIDCClientInformation, String> strategy) {
        this.checkSetterPreconditions();
        this.keyTransportEncryptionAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Key transport encryption algorithm lookup strategy cannot be null");
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setErrorEventId(@Nonnull String id) {
        this.checkSetterPreconditions();
        this.errorEventId = Constraint.isNotEmpty((String)id, (String)"Error event identifier cannot be empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.jwtTokenLookupStrategy == null) {
            throw new ComponentInitializationException("JwtTokenLookupStrategy cannot be null");
        }
        if (this.dataEncryptionAlgorithmLookupStrategy == null) {
            throw new ComponentInitializationException("DataEncryptionAlgorithmLookupStrategy cannot be null");
        }
        if (this.keyTransportEncryptionAlgorithmLookupStrategy == null) {
            throw new ComponentInitializationException("KeyTransportEncryptionAlgorithmLookupStrategy cannot be null");
        }
        if (this.clientInformationLookupStrategy == null) {
            throw new ComponentInitializationException("ClientInformationLookupStrategy cannot be null");
        }
        if (this.encryptionOptionalPredicate == null) {
            throw new ComponentInitializationException("EncryptionOptionalPredicate cannot be null");
        }
        if (StringSupport.trimOrNull((String)this.errorEventId) == null) {
            throw new ComponentInitializationException("ErrorEventId cannot be empty");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.encryptionOptional = this.encryptionOptionalPredicate.test(profileRequestContext);
        JWT jwt = this.jwtTokenLookupStrategy.apply(profileRequestContext);
        if (jwt == null || !(jwt instanceof EncryptedJWT)) {
            if (this.encryptionOptional) {
                this.log.debug("{} Extracted JWT was not an EncryptedJWT, but encryption is set to optional", (Object)this.getLogPrefix());
                return false;
            }
            this.log.warn("{} Extracted JWT was not an EncryptedJWT and encryption is not optional, publishing {}", (Object)this.getLogPrefix(), (Object)this.errorEventId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.errorEventId);
            return false;
        }
        this.encryptedJwt = (EncryptedJWT)jwt;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String expectedEncryptionMethod;
        String expectedJweAlgorithm;
        JWEHeader jweHeader = this.encryptedJwt.getHeader();
        OIDCClientInformation clientInformation = this.clientInformationLookupStrategy.apply(profileRequestContext);
        String tokenJweAlgorithm = jweHeader.getAlgorithm().getName();
        String string = expectedJweAlgorithm = clientInformation == null ? null : this.keyTransportEncryptionAlgorithmLookupStrategy.apply(clientInformation);
        if (StringSupport.trimOrNull(expectedJweAlgorithm) == null) {
            this.log.debug("{} No expected algorithm defined, accepting {} from the token", (Object)this.getLogPrefix(), (Object)tokenJweAlgorithm);
        } else if (tokenJweAlgorithm.equals(expectedJweAlgorithm)) {
            this.log.debug("{} The algorithm specified in the token was expected {}", (Object)this.getLogPrefix(), (Object)tokenJweAlgorithm);
        } else {
            this.log.warn("{} The algorithnm specified in the token {} was not expected {}", new Object[]{this.getLogPrefix(), tokenJweAlgorithm, expectedJweAlgorithm});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.errorEventId);
            return;
        }
        String tokenEncryptionMethod = jweHeader.getEncryptionMethod().getName();
        String string2 = expectedEncryptionMethod = clientInformation == null ? null : this.dataEncryptionAlgorithmLookupStrategy.apply(clientInformation);
        if (StringSupport.trimOrNull(expectedEncryptionMethod) == null) {
            this.log.debug("{} No expected encryption method defined, accepting {} from the token", (Object)this.getLogPrefix(), (Object)tokenEncryptionMethod);
        } else if (tokenEncryptionMethod.equals(expectedEncryptionMethod)) {
            this.log.debug("{} The encryption method specified in the token was expected {}", (Object)this.getLogPrefix(), (Object)tokenEncryptionMethod);
        } else {
            this.log.warn("{} The encryption method specified in the token {} was not expected {}", new Object[]{this.getLogPrefix(), tokenEncryptionMethod, expectedEncryptionMethod});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.errorEventId);
        }
    }
}

