/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.impl.AlgorithmRuntimeSupportedPredicate;

public abstract class AbstractEncryptionAlgorithmsLookupStrategy
implements BiFunction<CriteriaSet, Predicate<String>, List<String>> {
    @Nonnull
    private final AlgorithmRegistry algorithmRegistry;

    protected AbstractEncryptionAlgorithmsLookupStrategy(@Nullable AlgorithmRegistry registry) {
        this.algorithmRegistry = registry == null ? AlgorithmSupport.ensureGlobalAlgorithmRegistry() : registry;
    }

    @Nonnull
    protected Predicate<String> getAlgorithmRuntimeSupportedPredicate() {
        return new AlgorithmRuntimeSupportedPredicate(this.getAlgorithmRegistry());
    }

    @Nonnull
    protected AlgorithmRegistry getAlgorithmRegistry() {
        return this.algorithmRegistry;
    }

    @Nonnull
    protected List<String> findAlgorithmIntersection(@Nonnull List<String> providerAlgorithms, @Nonnull List<String> configAlgorithms) {
        return (List)((NonnullSupplier)configAlgorithms.stream().filter(providerAlgorithms::contains).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }
}

