/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class KeyManagmentAlgorithmCriterion
implements Criterion {
    @Nonnull
    private String algorithmName;

    public KeyManagmentAlgorithmCriterion(@Nonnull String algorithm) {
        String trimmed = StringSupport.trimOrNull((String)algorithm);
        this.algorithmName = (String)Constraint.isNotNull((Object)trimmed, (String)"Key Management algorithm criteria cannot be null or empty");
    }

    @Nonnull
    public String getAlgorithm() {
        return this.algorithmName;
    }

    public void setAlgorithm(@Nonnull String algorithm) {
        String trimmed = StringSupport.trimOrNull((String)algorithm);
        this.algorithmName = (String)Constraint.isNotNull((Object)trimmed, (String)"Key Management algorithm criteria cannot be null or empty");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyManagmentAlgorithmCriterion [algorithm=");
        builder.append(this.algorithmName);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.algorithmName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof KeyManagmentAlgorithmCriterion) {
            KeyManagmentAlgorithmCriterion c = (KeyManagmentAlgorithmCriterion)obj;
            return this.algorithmName.equals(c.algorithmName);
        }
        return false;
    }
}

