/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.Header;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.credential.impl.DataEncryptionAlgorithmCriterion;
import net.shibboleth.oidc.security.credential.impl.EvaluableKeyIDCredentialCriterion;
import net.shibboleth.oidc.security.credential.impl.KeyManagmentAlgorithmCriterion;
import net.shibboleth.oidc.security.jose.criterion.JOSEObjectCriterion;
import net.shibboleth.oidc.security.jose.criterion.KeyIdCriterion;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;

public class BasicJOSEObjectCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver
implements JOSEObjectCredentialResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicJOSEObjectCredentialResolver.class);

    @Nonnull
    @NonnullElements
    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        JOSEObjectCriterion joseObjectCriteria = null;
        if (criteriaSet != null) {
            joseObjectCriteria = (JOSEObjectCriterion)criteriaSet.get(JOSEObjectCriterion.class);
        }
        if (joseObjectCriteria == null) {
            this.log.error("No JOSEObject criteria supplied, resolver could not process");
            throw new ResolverException("Credential criteria set did not contain an instance of JOSEObjectCriterion");
        }
        JOSEObject joseObject = joseObjectCriteria.getJOSEObject();
        if (joseObject == null) {
            throw new ResolverException("JOSEObjectCriterion did not contain an instance of JOSEObject");
        }
        List<Credential> credentials = null;
        Header header = joseObject.getHeader();
        if (header instanceof JWSHeader) {
            JWSHeader jwsHeader = (JWSHeader)header;
            credentials = this.processJWSHeader(jwsHeader);
        } else if (header instanceof JWEHeader) {
            JWEHeader jweHeader = (JWEHeader)header;
            credentials = this.processJWEHeader(jweHeader);
        } else {
            throw new ResolverException("Saw unknown JOSEObject header type: " + header.getClass().getName());
        }
        this.postProcess(criteriaSet, joseObject, credentials);
        this.log.debug("A total of {} credentials were resolved from the JOSE headers", (Object)credentials.size());
        return credentials;
    }

    protected void postProcess(@Nullable CriteriaSet criteriaSet, @Nonnull JOSEObject joseObject, @Nonnull List<Credential> credentials) throws ResolverException {
    }

    @Nonnull
    @NonnullElements
    protected List<Credential> processJWSHeader(@Nonnull JWSHeader jwsHeader) {
        BasicJWKCredential cred;
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        JWK jwk = jwsHeader.getJWK();
        if (jwk != null && (cred = this.buildJWKCredential(jwk, jwsHeader.getKeyID())) != null) {
            credentials.add((Credential)cred);
        }
        return credentials;
    }

    @Nonnull
    @NonnullElements
    protected List<Credential> processJWEHeader(@Nonnull JWEHeader jweHeader) {
        BasicJWKCredential cred;
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        JWK jwk = jweHeader.getJWK();
        if (jwk != null && (cred = this.buildJWKCredential(jwk, jweHeader.getKeyID())) != null) {
            credentials.add((Credential)cred);
        }
        return credentials;
    }

    @Nullable
    protected BasicJWKCredential buildJWKCredential(@Nonnull JWK jwk, @Nullable String headerKid) {
        BasicJWKCredential credential = new BasicJWKCredential();
        if ((jwk.getKeyType() == KeyType.EC || jwk.getKeyType() == KeyType.RSA) && jwk instanceof AsymmetricJWK) {
            AsymmetricJWK asymmetricJwk = (AsymmetricJWK)jwk;
            try {
                PublicKey publicKey = asymmetricJwk.toPublicKey();
                if (publicKey != null) {
                    credential.setPublicKey(publicKey);
                }
                this.log.warn("Public key was null in JWK");
            }
            catch (JOSEException e) {
                this.log.warn("Could not parse public key from JWK", (Throwable)e);
                return null;
            }
        } else {
            this.log.warn("Unsupported key type {} found from JWK", (Object)jwk.getKeyType());
            return null;
        }
        if (jwk.getKeyID() != null) {
            credential.getKeyNames().add(jwk.getKeyID());
            credential.setKid(jwk.getKeyID());
        }
        if (jwk.getAlgorithm() != null) {
            credential.setAlgorithm(jwk.getAlgorithm());
        }
        if (headerKid != null && !headerKid.equals(credential.getKid())) {
            this.log.warn("Key ID in JOSE header does not match 'kid' in JWK");
            return null;
        }
        if (jwk.getKeyUse() != null) {
            credential.setUsageType(CredentialConversionUtil.getUsageType((JWK)jwk));
        }
        return credential;
    }

    @Nullable
    protected String extractKeyIdFromCriteria(@Nonnull CriteriaSet criteriaSet) {
        EvaluableKeyIDCredentialCriterion evalCrit = (EvaluableKeyIDCredentialCriterion)((Object)criteriaSet.get(EvaluableKeyIDCredentialCriterion.class));
        if (evalCrit != null) {
            return evalCrit.getKeyId();
        }
        KeyIdCriterion keyIdCrit = (KeyIdCriterion)criteriaSet.get(KeyIdCriterion.class);
        if (keyIdCrit != null) {
            return keyIdCrit.getKeyId();
        }
        return null;
    }

    protected void populateCredentialsFromKeySet(@Nonnull JWKSet keySet, @Nonnull Collection<Credential> credentials) {
        for (JWK key : keySet.getKeys()) {
            if (!(key instanceof RSAKey) && !(key instanceof ECKey)) continue;
            try {
                Credential cred = CredentialConversionUtil.keyToCredential((JWK)key);
                if (cred == null) continue;
                this.log.trace("Found key '{}' of type '{}' with usage '{}' {}", new Object[]{key.getKeyID(), key.getKeyType(), key.getKeyUse(), key.getAlgorithm() != null ? ", and alg: " + String.valueOf(key.getAlgorithm()) : ""});
                credentials.add(cred);
            }
            catch (JOSEException e) {
                this.log.trace("Unable to convert key '{}' to credential", (Object)key.getKeyID(), (Object)e);
            }
        }
    }

    @Nullable
    protected Credential deriveClientSecretCredential(@Nonnull ClientSecretCredential secretCred, @Nonnull CriteriaSet criteriaSet) throws ResolverException {
        UsageCriterion usageTypeCriterion = (UsageCriterion)criteriaSet.get(UsageCriterion.class);
        if (usageTypeCriterion == null) {
            this.log.trace("No usage type criterion supplied, unable to derive client_secret credential");
            return null;
        }
        UsageType usageType = usageTypeCriterion.getUsage();
        if (usageType == UsageType.SIGNING) {
            JWKCredential signingCred = secretCred.toSigningCredential();
            this.log.debug("Derived signing credential '{}'", (Object)signingCred.getKeyNames());
            return signingCred;
        }
        if (usageType == UsageType.ENCRYPTION) {
            KeyManagmentAlgorithmCriterion alg = (KeyManagmentAlgorithmCriterion)criteriaSet.get(KeyManagmentAlgorithmCriterion.class);
            if (alg == null) {
                throw new ResolverException("Credential criteria set did not contain an instance of KeyManagmentAlgorithmCriterion");
            }
            DataEncryptionAlgorithmCriterion enc = (DataEncryptionAlgorithmCriterion)criteriaSet.get(DataEncryptionAlgorithmCriterion.class);
            if (enc == null) {
                throw new ResolverException("Credential criteria set did not contain an instance of DataEncryptionAlgorithmCriterion");
            }
            if (JWEAlgorithm.Family.SYMMETRIC.contains((Object)JWEAlgorithm.parse((String)alg.getAlgorithm()))) {
                try {
                    JWEAlgorithm jweAlgorithm = JWEAlgorithm.parse((String)alg.getAlgorithm());
                    EncryptionMethod encryptionMethod = EncryptionMethod.parse((String)enc.getEncAlgorithm());
                    assert (jweAlgorithm != null);
                    assert (encryptionMethod != null);
                    JWKCredential derivedCred = secretCred.toEncryptionCredential(jweAlgorithm, encryptionMethod);
                    this.log.debug("Derived encryption credential '{}' from 'alg={}' and 'enc={}'", new Object[]{derivedCred.getKeyNames(), alg.getAlgorithm(), enc.getEncAlgorithm()});
                    return derivedCred;
                }
                catch (JOSEException e) {
                    this.log.warn("Unable to derive symmetric encryption key from client_secret using 'alg={}' and 'enc={}'", (Object)alg.getAlgorithm(), (Object)enc.getEncAlgorithm());
                    throw new ResolverException("Unable to create encryption key from client_secret");
                }
            }
        } else {
            this.log.trace("Client secret could not be derived, unknown usage type '{}'", (Object)usageType);
            throw new ResolverException("Unable to create key from client_secret, incompatible usage type");
        }
        this.log.trace("Asymmetric key requested, client_secret not appropriate");
        return null;
    }
}

