/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.credential.DefaultClientSecretCredential;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public abstract class AbstractClientInformationCredentialResolver
extends BasicJOSEObjectCredentialResolver
implements InitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractClientInformationCredentialResolver.class);
    private boolean isInitialized;

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() throws ComponentInitializationException {
        this.isInitialized = true;
    }

    @Nonnull
    protected Collection<Credential> resolveSecretCredentials(@Nullable CriteriaSet criteriaSet) {
        if (criteriaSet != null) {
            OIDCClientInformation information;
            Secret secret;
            ClientInformationCriterion clientCrit = (ClientInformationCriterion)criteriaSet.get(ClientInformationCriterion.class);
            if (clientCrit != null && (secret = (information = clientCrit.getOidcClientInformation()).getSecret()) != null) {
                String secretValue = secret.getValue();
                assert (secretValue != null);
                LinkedHashSet<Credential> credentials = new LinkedHashSet<Credential>(1);
                try {
                    DefaultClientSecretCredential secretCred = new DefaultClientSecretCredential(secretValue);
                    Credential derivedCredential = this.deriveClientSecretCredential((ClientSecretCredential)secretCred, criteriaSet);
                    if (derivedCredential != null) {
                        credentials.add(derivedCredential);
                    }
                }
                catch (ResolverException e) {
                    this.log.warn("Unable to derive a client_secret based credential", (Throwable)e);
                }
                return credentials;
            }
        } else {
            this.log.debug("Criteria did not contain a ClientInformationCriterion could not perform resolution");
        }
        return CollectionSupport.emptySet();
    }
}

