/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.criterion;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public class KeyIdCriterion
implements Criterion {
    @Nonnull
    private String keyId;

    public KeyIdCriterion(@Nonnull String id) {
        String trimmed = StringSupport.trimOrNull((String)id);
        this.keyId = (String)Constraint.isNotNull((Object)trimmed, (String)"Key ID criteria value cannot be null or empty");
    }

    @Nonnull
    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(@Nonnull String id) {
        String trimmed = StringSupport.trimOrNull((String)id);
        this.keyId = (String)Constraint.isNotNull((Object)trimmed, (String)"Key ID criteria value cannot be null or empty");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("KeyIdCriterion [keyId =");
        builder.append(this.keyId);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.keyId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof KeyIdCriterion) {
            return this.keyId.equals(((KeyIdCriterion)obj).keyId);
        }
        return false;
    }
}

