/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.util.StandardCharset;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.jose.SecretKeyDerivation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JWKCredential;

public final class JWKCredentialSupport {
    private JWKCredentialSupport() {
    }

    @Nullable
    public static final JWKCredential deriveSymmetricKeyForAlgAndEnc(@Nullable JWKCredential credential, @Nullable JWEAlgorithm alg, @Nullable EncryptionMethod enc) throws JOSEException {
        if (credential == null || alg == null || enc == null) {
            return null;
        }
        SecretKey skey = credential.getSecretKey();
        if (skey == null) {
            return null;
        }
        byte[] encoded = skey.getEncoded();
        assert (encoded != null);
        SecretKey derivedKey = JWKCredentialSupport.generateSymmetricKey(encoded, alg, enc);
        return CredentialConversionUtil.copySymmetricCredentialWithNewSecret(credential, "derived-" + CredentialConversionUtil.resolveKid(credential), derivedKey);
    }

    @Nonnull
    public static final SecretKey generateSymmetricKey(@Nonnull byte[] clientSecret, @Nonnull JWEAlgorithm alg, @Nonnull EncryptionMethod enc) throws JOSEException {
        SecretKey result = SecretKeyDerivation.deriveSecretKey((Secret)new Secret(new String(clientSecret, StandardCharset.UTF_8)), (JWEAlgorithm)alg, (EncryptionMethod)enc);
        assert (result != null);
        return result;
    }

    public static final SecretKey generateSymmetricKey(Secret clientSecret, JWEAlgorithm alg, EncryptionMethod enc) throws JOSEException {
        return SecretKeyDerivation.deriveSecretKey((Secret)clientSecret, (JWEAlgorithm)alg, (EncryptionMethod)enc);
    }
}

