/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import com.nimbusds.jose.crypto.impl.HMAC;
import com.nimbusds.jose.crypto.impl.MACProvider;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;

public final class JWSAssemblyUtils {
    private JWSAssemblyUtils() {
    }

    @Nonnull
    public static String assembleMacJwsAsString(@Nonnull JWSAlgorithm algorithm, @Nonnull JWTClaimsSet claimsSet, @Nonnull byte[] secret) throws EncodingException, JOSEException, ParseException {
        String result = JWSAssemblyUtils.assembleMacJws(algorithm, claimsSet, secret).serialize();
        assert (result != null);
        return result;
    }

    @Nonnull
    public static SignedJWT assembleMacJws(@Nonnull JWSAlgorithm algorithm, @Nonnull JWTClaimsSet claimsSet, @Nonnull byte[] secret) throws EncodingException, JOSEException, ParseException {
        Constraint.isNotNull((Object)algorithm, (String)"Algorithm can not be null");
        Constraint.isNotNull((Object)claimsSet, (String)"JWT claims can not be null");
        Constraint.isNotNull((Object)secret, (String)"Secret can not be null");
        JWSHeader header = new JWSHeader.Builder(algorithm).type(JOSEObjectType.JWT).build();
        assert (header != null);
        Payload payload = new Payload(claimsSet.toJSONObject());
        String signingInput = JWSAssemblyUtils.composeSigningInput(header, payload);
        byte[] hmac = HMAC.compute((String)JWSAssemblyUtils.getJCAAlgorithmName(algorithm), (SecretKey)new SecretKeySpec(secret, JWSAssemblyUtils.getJCAAlgorithmName(algorithm)), (byte[])signingInput.getBytes(StandardCharsets.UTF_8), null);
        SignedJWT signedJwt = new SignedJWT(header.toBase64URL(), payload.toBase64URL(), Base64URL.encode((byte[])hmac));
        return signedJwt;
    }

    @Nonnull
    public static byte[] getSecretBytes(@Nonnull String secret) {
        byte[] result = secret.getBytes(StandardCharsets.UTF_8);
        assert (result != null);
        return result;
    }

    @Nonnull
    private static String composeSigningInput(@Nonnull JWSHeader header, @Nonnull Payload payload) throws EncodingException {
        Constraint.isNotNull((Object)header, (String)"JWS Header can not be null");
        Constraint.isNotNull((Object)payload, (String)"JWT payload can not be null");
        return header.toBase64URL().toString() + "." + payload.toBase64URL().toString();
    }

    @Nonnull
    private static String getJCAAlgorithmName(@Nonnull JWSAlgorithm alg) throws JOSEException {
        Constraint.isNotNull((Object)alg, (String)"Algorithm can not be null");
        if (alg.equals((Object)JWSAlgorithm.HS256)) {
            return "HMACSHA256";
        }
        if (alg.equals((Object)JWSAlgorithm.HS384)) {
            return "HMACSHA384";
        }
        if (alg.equals((Object)JWSAlgorithm.HS512)) {
            return "HMACSHA512";
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm((JWSAlgorithm)alg, (Collection)MACProvider.SUPPORTED_ALGORITHMS));
    }
}

