/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class RequiredClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    @NonnullElements
    private Set<String> requiredClaims = CollectionSupport.emptySet();

    public void setRequiredClaims(@Nullable Collection<String> claims) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requiredClaims = claims != null ? CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(claims)) : CollectionSupport.emptySet();
    }

    public void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        if (!claims.getClaims().keySet().containsAll(this.requiredClaims)) {
            HashSet<String> missingClaims = new HashSet<String>(this.requiredClaims);
            missingClaims.removeAll(claims.getClaims().keySet());
            throw new JWTValidationException("JWT missing required claims: " + String.valueOf(missingClaims));
        }
    }
}

