/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class IssuedAtClaimsValidator
extends AbstractClaimsValidator {
    @Nonnull
    private Duration clockSkew;
    @Nonnull
    private Duration messageLifetime = Duration.ofMinutes(1L);
    private boolean requiredRule = true;

    public IssuedAtClaimsValidator() {
        this.clockSkew = Duration.ofMinutes(1L);
    }

    public void setMessageLifetime(@Nonnull Duration lifetime) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        Constraint.isNotNull((Object)lifetime, (String)"Token lifetime cannot be null");
        Constraint.isFalse((boolean)lifetime.isNegative(), (String)"Token lifetime cannot be negative");
        this.messageLifetime = lifetime;
    }

    public void setClockSkew(@Nonnull Duration skew) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clockSkew = (Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
    }

    public void setRequiredRule(boolean required) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requiredRule = required;
    }

    public void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        Date iatDate = claims.getIssueTime();
        if (iatDate != null) {
            Instant iat = iatDate.toInstant();
            Instant now = Instant.now();
            Instant latestValid = now.plus(this.clockSkew.abs());
            Instant expiration = iat.plus(this.clockSkew.abs()).plus(this.messageLifetime);
            if (iat.isAfter(latestValid)) {
                throw new JWTValidationException("JWT was rejected because it was issued in the future. Token issued at '" + String.valueOf(iat) + "' was too far away from the current time '" + String.valueOf(now) + "' with acceptable lifetime of '" + String.valueOf(this.messageLifetime) + "', clockSkew of '" + String.valueOf(this.clockSkew) + "'");
            }
            if (expiration.isBefore(now)) {
                throw new JWTValidationException("JWT was rejected due to issue instance expiration. Token issued at '" + String.valueOf(iat) + "' was too far away from the current time '" + String.valueOf(now) + "' with acceptable lifetime of '" + String.valueOf(this.messageLifetime) + "', clockSkew of '" + String.valueOf(this.clockSkew) + "'");
            }
        } else if (this.requiredRule) {
            throw new JWTValidationException("JWT was rejected due to missing required 'iat' claim.");
        }
    }
}

