/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.AbstractClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class ACRClaimsValidator
extends AbstractClaimsValidator {
    @NonnullAfterInit
    private BiFunction<ProfileRequestContext, JWTClaimsSet, List<String>> requestedEssentialAcrsClaimLookupStrategy;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.requestedEssentialAcrsClaimLookupStrategy == null) {
            throw new ComponentInitializationException("Requested Essential ACR Claim Lookup Strategy can not be null");
        }
    }

    public void setRequestedEssentialAcrsClaimLookupStrategy(@Nonnull BiFunction<ProfileRequestContext, JWTClaimsSet, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.requestedEssentialAcrsClaimLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"requestedAcrClaimLookupStrategy can not be null");
    }

    protected void doValidate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        List<String> requestedClaims = this.requestedEssentialAcrsClaimLookupStrategy.apply(context, claims);
        if (requestedClaims == null || requestedClaims.isEmpty()) {
            return;
        }
        try {
            String receivedAcrClaim = claims.getStringClaim("acr");
            if (receivedAcrClaim == null) {
                throw new JWTValidationException("ACR claim requested but not received inside ID Token");
            }
            boolean receivedWasRequested = requestedClaims.contains(receivedAcrClaim);
            if (!receivedWasRequested) {
                throw new JWTValidationException("Did not receive one of the requested ACR claim values. Requested '" + requestedClaims.toString() + "', received '" + receivedAcrClaim + "'");
            }
        }
        catch (ParseException e) {
            throw new JWTValidationException("ACR claim requested, but none received inside ID Token");
        }
    }
}

