/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.oidc.security.jose.impl.DefaultKeyTransportEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.slf4j.Logger;

public class ProviderMetadataKeyTransportEncryptionAlgorithmsLookupStrategy
extends DefaultKeyTransportEncryptionAlgorithmsLookupStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataKeyTransportEncryptionAlgorithmsLookupStrategy.class);
    @Nonnull
    private final Function<OIDCProviderMetadata, List<String>> providerKeyTransportAlgorithmsLookupStrategy;

    public ProviderMetadataKeyTransportEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="providerKeyTransportAlgorithmsLookupStrategy") Function<OIDCProviderMetadata, List<String>> strategy, @Nullable @ParameterName(name="AlgorithmRegistry") AlgorithmRegistry registry) {
        super(registry);
        this.providerKeyTransportAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The provider key transport lookup strategy can not be null");
    }

    public ProviderMetadataKeyTransportEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="providerKeyTransportAlgorithmsLookupStrategy") Function<OIDCProviderMetadata, List<String>> strategy) {
        super(null);
        this.providerKeyTransportAlgorithmsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The provider key transport lookup strategy can not be null");
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable CriteriaSet criteria, @Nullable Predicate<String> includeExcludePredicate) {
        OIDCProviderMetadata metadata;
        ProviderMetadataCriterion metaCrit = criteria != null ? (ProviderMetadataCriterion)criteria.get(ProviderMetadataCriterion.class) : null;
        OIDCProviderMetadata oIDCProviderMetadata = metadata = metaCrit != null ? metaCrit.getMetadata() : null;
        if (metadata == null) {
            this.log.debug("No provider metadata, falling back to default local behaviour");
            return super.apply(criteria, includeExcludePredicate);
        }
        List<String> keyTransportAlgorithms = this.providerKeyTransportAlgorithmsLookupStrategy.apply(metadata);
        this.log.trace("Resolved effective key transport algorithms from provider metadata: {}", keyTransportAlgorithms);
        if (keyTransportAlgorithms == null) {
            this.log.debug("Provider metadata does not contain supported 'alg' algorithms, falling back to default local behaviour");
            return super.apply(criteria, includeExcludePredicate);
        }
        List<String> keyTransportAlgorithmSupported = this.getKeyTransportAlgorithmsFromConfiguration(criteria, includeExcludePredicate);
        this.log.trace("Resolved supported key transport algorithms from config: {}", keyTransportAlgorithmSupported);
        List<String> supportedAndConfiguredKeyTransportAlgorithms = this.findAlgorithmIntersection(keyTransportAlgorithms, keyTransportAlgorithmSupported);
        this.log.debug("Supported and configured key transport algorithms: {}", supportedAndConfiguredKeyTransportAlgorithms);
        if (supportedAndConfiguredKeyTransportAlgorithms.isEmpty()) {
            this.log.warn("No supported key transport algorithm. Provider metadata and configuration are not compatible");
            return Collections.emptyList();
        }
        return supportedAndConfiguredKeyTransportAlgorithms;
    }
}

