/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.impl.DefaultDataEncryptionAlgorithmsLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.xmlsec.algorithm.AlgorithmRegistry;
import org.slf4j.Logger;

public class ClientInformationDataEncryptionAlgorithmsLookupStrategy
extends DefaultDataEncryptionAlgorithmsLookupStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientInformationDataEncryptionAlgorithmsLookupStrategy.class);
    @Nonnull
    private final Function<OIDCClientInformation, String> clientEncryptionMethodLookupStrategy;

    public ClientInformationDataEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="clientEncryptionMethodLookupStrategy") Function<OIDCClientInformation, String> strategy, @Nullable @ParameterName(name="AlgorithmRegistry") AlgorithmRegistry registry) {
        super(registry);
        this.clientEncryptionMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The client key transport lookup strategy can not be null");
    }

    public ClientInformationDataEncryptionAlgorithmsLookupStrategy(@Nonnull @ParameterName(name="clientEncryptionMethodLookupStrategy") Function<OIDCClientInformation, String> strategy) {
        this(strategy, null);
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable CriteriaSet criteria, @Nullable Predicate<String> includeExcludePredicate) {
        OIDCClientInformation metadata;
        ClientInformationCriterion clientCrit = criteria != null ? (ClientInformationCriterion)criteria.get(ClientInformationCriterion.class) : null;
        OIDCClientInformation oIDCClientInformation = metadata = clientCrit != null ? clientCrit.getOidcClientInformation() : null;
        if (metadata == null) {
            this.log.debug("No client metadata, falling back to default local behaviour");
            return super.apply(criteria, includeExcludePredicate);
        }
        String dataEncryptionMethod = this.clientEncryptionMethodLookupStrategy.apply(metadata);
        this.log.trace("Resolved effective data encryption algorithms from client metadata: {}", (Object)dataEncryptionMethod);
        if (dataEncryptionMethod == null) {
            this.log.debug("Client metadata does not contain 'enc' algorithm value, returning empty list");
            return Collections.emptyList();
        }
        List<String> dataEncryptionAlgorithmsSupported = this.getDataEncryptionAlgorithmsFromConfiguration(criteria, includeExcludePredicate);
        this.log.trace("Resolved supported data encryption algorithms from config: {}", dataEncryptionAlgorithmsSupported);
        if (dataEncryptionAlgorithmsSupported.contains(dataEncryptionMethod)) {
            this.log.debug("The algorithm configured in the metadata is supported");
            return List.of(dataEncryptionMethod);
        }
        this.log.warn("No supported data encryption method. Client metadata and configuration are not compatible");
        return Collections.emptyList();
    }
}

