/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.jose.criterion.JOSEObjectCriterion;
import net.shibboleth.oidc.security.jose.criterion.SignatureValidationParametersCriterion;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;

public abstract class BaseSignedJWTTrustEngine<TrustBasisType>
implements TrustEngine<SignedJWT> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseSignedJWTTrustEngine.class);
    @Nonnull
    private final JOSEObjectCredentialResolver joseObjectCredentialResolver;

    protected BaseSignedJWTTrustEngine(@Nonnull JOSEObjectCredentialResolver joseObjectResolver) {
        this.joseObjectCredentialResolver = (JOSEObjectCredentialResolver)Constraint.isNotNull((Object)joseObjectResolver, (String)"JOSEObject credential resolver cannot be null");
    }

    public boolean validate(@Nonnull SignedJWT signedJWT, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        SignatureValidationParametersCriterion validationCriterion;
        this.checkParams(signedJWT, trustBasisCriteria);
        assert (trustBasisCriteria != null);
        SignatureValidationParametersCriterion signatureValidationParametersCriterion = validationCriterion = trustBasisCriteria != null ? (SignatureValidationParametersCriterion)trustBasisCriteria.get(SignatureValidationParametersCriterion.class) : null;
        if (validationCriterion != null) {
            this.log.debug("Performing signature algorithm include/exclude validation using params from CriteriaSet");
            JWSAlgorithm algorithm = signedJWT.getHeader().getAlgorithm();
            String algName = algorithm.getName();
            assert (algName != null);
            if (!AlgorithmSupport.validateAlgorithmURI((String)algName, (Collection)validationCriterion.getSignatureValidationParameters().getIncludedAlgorithms(), (Collection)validationCriterion.getSignatureValidationParameters().getExcludedAlgorithms())) {
                this.log.warn("Algorithm failed include/exclude validation: {}", (Object)algorithm.getName());
                return false;
            }
        }
        return this.doValidate(signedJWT, trustBasisCriteria);
    }

    protected abstract boolean doValidate(@Nonnull SignedJWT var1, @Nonnull CriteriaSet var2) throws SecurityException;

    protected boolean validate(@Nonnull SignedJWT signedJWT, @Nullable TrustBasisType trustBasis) throws SecurityException {
        this.log.debug("Attempting to verify signature and establish trust using token-derived credentials");
        Collection<Credential> tokenCredentials = this.resolveTokenCredentials(signedJWT);
        if (!tokenCredentials.isEmpty()) {
            this.log.debug("Resolved {} token-derived credentials", (Object)tokenCredentials.size());
            for (Credential tokenCred : tokenCredentials) {
                assert (tokenCred != null);
                if (!this.verifySignature(signedJWT, tokenCred)) continue;
                this.log.debug("Successfully verified signature using token-derived credential");
                this.log.debug("Attempting to establish trust of token-derived credential");
                if (this.evaluateTrust(tokenCred, trustBasis)) {
                    this.log.debug("Successfully established trust of token-derived credential");
                    return true;
                }
                this.log.debug("Failed to establish trust of token-derived credential");
            }
        } else {
            this.log.debug("SignedJWT contained no resolveable credentials, nothing to evaluate");
        }
        this.log.debug("Failed to verify signature and/or establish trust using any token-derived credentials");
        return false;
    }

    protected boolean verifySignature(@Nonnull SignedJWT signedJWT, @Nonnull Credential credential) throws SecurityException {
        try {
            JWSAlgorithm algorithm = signedJWT.getHeader().getAlgorithm();
            JWSVerifier verifier = BaseSignedJWTTrustEngine.initializeVerifier((Algorithm)algorithm, credential);
            if (verifier == null) {
                this.log.debug("No verifier for given JWT and Credential pair for alg {}", (Object)algorithm.getName());
                return false;
            }
            if (signedJWT.verify(verifier)) {
                if (this.log.isDebugEnabled()) {
                    String kid = credential instanceof JWKCredential ? ((JWKCredential)credential).getKid() : null;
                    this.log.debug("Verified JWT using algorithm {}{}: {} ", new Object[]{algorithm.getName(), kid != null ? " and key " + kid : "", signedJWT.serialize()});
                }
                this.log.debug("Signature validation using candidate credential was successful");
                return true;
            }
            this.log.debug("Unable to validate given JWT with credential '{}'", (Object)CredentialConversionUtil.resolveKid((Credential)credential));
            return false;
        }
        catch (JOSEException | IllegalStateException e) {
            String kid = credential instanceof JWKCredential ? ((JWKCredential)credential).getKid() : null;
            this.log.warn("Exception caught when validating given JWT{}", kid != null ? " with credential " + kid : "", (Object)e);
            return false;
        }
    }

    private static JWSVerifier initializeVerifier(Algorithm algorithm, Credential credential) throws JOSEException {
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)algorithm) && credential.getSecretKey() != null) {
            return new MACVerifier(credential.getSecretKey());
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)algorithm) && credential.getPublicKey() instanceof RSAPublicKey) {
            return new RSASSAVerifier((RSAPublicKey)credential.getPublicKey());
        }
        if (JWSAlgorithm.Family.EC.contains((Object)algorithm) && credential.getPublicKey() instanceof ECPublicKey) {
            return new ECDSAVerifier((ECPublicKey)credential.getPublicKey());
        }
        return null;
    }

    protected abstract boolean evaluateTrust(@Nonnull Credential var1, @Nullable TrustBasisType var2) throws SecurityException;

    protected void checkParams(@Nullable SignedJWT signedJWT, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        if (signedJWT == null) {
            throw new SecurityException("SignedJWT cannot be null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set cannot be null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set cannot be empty");
        }
    }

    @Nonnull
    protected Collection<Credential> resolveTokenCredentials(@Nonnull SignedJWT signedJWT) throws SecurityException {
        try {
            ArrayList<Credential> creds = new ArrayList<Credential>();
            this.joseObjectCredentialResolver.resolve((Object)new CriteriaSet(new Criterion[]{new JOSEObjectCriterion((JOSEObject)signedJWT)})).forEach(creds::add);
            return creds;
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving credentials from JOSEObject", (Exception)((Object)e));
        }
    }
}

