/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.impl;

import com.google.common.base.Strings;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableClientProfileConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.jose.SignatureValidationParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.criterion.ClientSecretCredentialCriterion;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.oidc.security.jose.criterion.SignatureValidationParametersCriterion;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.messaging.impl.BaseTrustEngineSecurityHandler;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;

public abstract class BaseJWTSignatureSecurityHandler
extends BaseTrustEngineSecurityHandler<SignedJWT> {
    @Nonnull
    private static final ParentProfileRequestContextLookup<MessageContext> PRC_LOOKUP = new ParentProfileRequestContextLookup();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseJWTSignatureSecurityHandler.class);
    @Nonnull
    private Function<MessageContext, OIDCProviderMetadata> providerMetadataLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<MessageContext, OIDCClientInformation> clientInformationLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true);
    @Nullable
    private OAuth2ClientAuthenticableClientProfileConfiguration profileConfiguration;
    @Nullable
    private OIDCPeerEntityContext peerContext;
    @Nullable
    private OIDCProviderMetadata providerMetadata;
    @Nullable
    private OIDCClientInformation clientInformation;

    protected BaseJWTSignatureSecurityHandler() {
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setProviderMetadataLookupStrategy(@Nonnull Function<MessageContext, OIDCProviderMetadata> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.providerMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Provider metadata lookup strategy can not be null");
    }

    public void setClientInformationLookupStrategy(@Nonnull Function<MessageContext, OIDCClientInformation> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientInformationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Client information lookup strategy can not be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nullable
    protected OIDCPeerEntityContext getOIDCPeerEntityContext() {
        return this.peerContext;
    }

    @Nullable
    protected TrustEngine<SignedJWT> resolveTrustEngine(@Nonnull MessageContext messageContext) {
        SignatureValidationParameters valParams;
        SecurityParametersContext secParams = this.securityParametersContextLookupStrategy.apply(messageContext);
        SignatureValidationParameters signatureValidationParameters = valParams = secParams != null ? secParams.getSignatureValidationParameters() : null;
        if (valParams == null) {
            return null;
        }
        return valParams.getSignatureTrustEngine();
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.providerMetadata = this.providerMetadataLookupStrategy.apply(messageContext);
        this.clientInformation = this.clientInformationLookupStrategy.apply(messageContext);
        this.peerContext = (OIDCPeerEntityContext)messageContext.getSubcontext(OIDCPeerEntityContext.class);
        RelyingPartyContext rpCtx = this.adapt(this.relyingPartyContextLookupStrategy).apply(messageContext);
        if (rpCtx != null && rpCtx.getConfiguration() != null && rpCtx.getProfileConfig() instanceof OAuth2ClientAuthenticableProfileConfiguration) {
            this.profileConfiguration = (OAuth2ClientAuthenticableClientProfileConfiguration)rpCtx.getProfileConfig();
        }
        return true;
    }

    protected CriteriaSet buildCriteriaSet(@Nullable String entityID, @Nonnull MessageContext messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = new CriteriaSet();
        if (!Strings.isNullOrEmpty((String)entityID)) {
            criteriaSet.add((Object)new IssuerIDCriterion(new Issuer(entityID)));
        }
        if (this.providerMetadata != null) {
            criteriaSet.add((Object)new ProviderMetadataCriterion(this.providerMetadata));
        }
        if (this.clientInformation != null) {
            criteriaSet.add((Object)new ClientInformationCriterion(this.clientInformation));
        }
        if (this.profileConfiguration != null) {
            ClientSecretCredential credential = this.profileConfiguration.getClientCredential((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext));
            if (credential != null) {
                criteriaSet.add((Object)new ClientSecretCredentialCriterion(credential));
            } else {
                this.log.trace("{} No client_secret credential found from the profile configuration", (Object)this.getLogPrefix());
            }
        }
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        SecurityParametersContext secParams = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (secParams == null) {
            throw new MessageHandlerException("Security parameters context could not be found, must be set");
        }
        SignatureValidationParameters valParams = secParams.getSignatureValidationParameters();
        if (valParams != null) {
            criteriaSet.add((Object)new SignatureValidationParametersCriterion(valParams));
        }
        return criteriaSet;
    }

    @Nonnull
    protected <T> Function<MessageContext, T> adapt(@Nonnull Function<ProfileRequestContext, T> function) {
        return function.compose(PRC_LOOKUP);
    }
}

