/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwk.RemoteJwkSetCache;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class ProviderMetadataCredentialResolver
extends BasicJOSEObjectCredentialResolver
implements InitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProviderMetadataCredentialResolver.class);
    private boolean isInitialized;
    @Nonnull
    private final RemoteJwkSetCache remoteJwkSetCache;
    @Positive
    private final Duration keyFetchInterval;

    public ProviderMetadataCredentialResolver(@Nonnull @ParameterName(name="remoteJwkSetCache") RemoteJwkSetCache jwkSetCache) {
        this(jwkSetCache, Duration.ofMinutes(30L));
    }

    public ProviderMetadataCredentialResolver(@Nonnull @ParameterName(name="remoteJwkSetCache") RemoteJwkSetCache jwkSetCache, @Nonnull @ParameterName(name="keyFetchInterval") @Positive Duration interval) {
        this.remoteJwkSetCache = (RemoteJwkSetCache)Constraint.isNotNull((Object)jwkSetCache, (String)"The remote JWK set cache cannot be null");
        Constraint.isFalse((interval == null || interval.isNegative() ? 1 : 0) != 0, (String)"Remote key refresh must be greater than 0");
        this.keyFetchInterval = interval;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() throws ComponentInitializationException {
        this.isInitialized = true;
    }

    @Override
    @Nonnull
    protected Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteriaSet) throws ResolverException {
        ProviderMetadataCriterion mc;
        if (criteriaSet != null && (mc = (ProviderMetadataCriterion)criteriaSet.get(ProviderMetadataCriterion.class)) != null) {
            return this.resolveFromMetadata(criteriaSet, mc.getMetadata());
        }
        this.log.debug("Criteria did not contain a ProviderMetadataCriterion could not perform resolution");
        return CollectionSupport.emptySet();
    }

    @Nonnull
    protected Collection<Credential> resolveFromMetadata(@Nonnull CriteriaSet criteriaSet, @Nonnull OIDCProviderMetadata metadata) {
        this.log.debug("Resolving JWKs from provider metadata");
        LinkedHashSet<Credential> credentials = new LinkedHashSet<Credential>(1);
        URI jwkSetUri = metadata.getJWKSetURI();
        if (jwkSetUri != null) {
            Instant now = Instant.now();
            assert (now != null);
            Instant nowPlusInterval = now.plus(this.keyFetchInterval);
            assert (nowPlusInterval != null);
            String keyIdFromCriteria = this.extractKeyIdFromCriteria(criteriaSet);
            JWKSet keySet = null;
            if (StringSupport.trimOrNull((String)keyIdFromCriteria) != null) {
                assert (keyIdFromCriteria != null);
                keySet = this.remoteJwkSetCache.fetch(jwkSetUri, keyIdFromCriteria, nowPlusInterval);
            } else {
                keySet = this.remoteJwkSetCache.fetch(jwkSetUri, nowPlusInterval);
            }
            if (keySet == null) {
                this.log.debug("Remote keys could not be fetched, unable to resolve credentials");
                return CollectionSupport.emptyList();
            }
            this.populateCredentialsFromKeySet(keySet, credentials);
        } else {
            this.log.trace("No JWK Set available, no credentials returned");
        }
        return credentials;
    }
}

