/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.jwt.claims;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractClaimsValidator
extends AbstractIdentifiableInitializableComponent
implements ClaimsValidator {
    @Nonnull
    private BiPredicate<ProfileRequestContext, JWTClaimsSet> activationCondition = (prc, claims) -> true;

    public void setActivationCondition(@Nonnull BiPredicate<ProfileRequestContext, JWTClaimsSet> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.activationCondition = (BiPredicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    @Override
    public void validate(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        if (!this.activationCondition.test(context, claims)) {
            return;
        }
        this.doValidate(claims, context);
    }

    protected abstract void doValidate(@Nonnull JWTClaimsSet var1, @Nonnull ProfileRequestContext var2) throws JWTValidationException;
}

