/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.jwk.support;

import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteJwkUtils {
    private RemoteJwkUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JWKSet fetchRemoteJwkSet(String logPrefix, URI uri, HttpClient httpClient, HttpClientSecurityParameters httpClientSecurityParameters) {
        String output;
        Logger log = LoggerFactory.getLogger(RemoteJwkUtils.class);
        ClassicHttpRequest get = ClassicRequestBuilder.get().setUri(uri).build();
        assert (get != null);
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)httpClientSecurityParameters, (boolean)true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)get);
        try (ClassicHttpResponse response = httpClient.executeOpen(null, get, (HttpContext)clientContext);){
            String scheme = get.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)scheme);
            if (response == null) {
                log.error("{} Could not get the JWK contents from {}", (Object)logPrefix, (Object)uri);
                JWKSet jWKSet = null;
                return jWKSet;
            }
            output = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (IOException | ParseException e) {
            log.error("{} Could not parse the JWK contents from {}", (Object)logPrefix, (Object)uri);
            return null;
        }
        catch (URISyntaxException e) {
            log.error("{} Could not build request URI from {}", new Object[]{logPrefix, uri, e});
            return null;
        }
        log.trace("{} Fetched the following response body: {}", (Object)logPrefix, (Object)output);
        if (output == null) {
            log.trace("{} Empty response body contents from {}", (Object)logPrefix, (Object)uri);
            return null;
        }
        try {
            Map json = JSONObjectUtils.parse((String)output);
            if (JSONObjectUtils.getJSONArray((Map)json, (String)"keys") != null) return JWKSet.parse((Map)json);
            log.error("{} Could not find 'keys' array from the JSON from {}", (Object)logPrefix, (Object)uri);
            return null;
        }
        catch (java.text.ParseException e) {
            log.error("{} Could not parse the contents from {}", new Object[]{logPrefix, uri, e});
            return null;
        }
    }
}

