/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.jwk;

import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwk.support.RemoteJwkUtils;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteJwkSetCache
extends AbstractIdentifiableInitializableComponent {
    public static final String CONTEXT_NAME = "oidcRemoteJwkSetContents";
    private final Logger log = LoggerFactory.getLogger(RemoteJwkSetCache.class);
    private StorageService storage;
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    @NonnullAfterInit
    public StorageService getStorage() {
        return this.storage;
    }

    public void setStorage(@Nonnull StorageService storageService) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.storage = (StorageService)Constraint.isNotNull((Object)storageService, (String)"StorageService cannot be null");
        StorageCapabilities caps = this.storage.getCapabilities();
        Constraint.isTrue((boolean)caps.isServerSide(), (String)"StorageService cannot be client-side");
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClientSecurityParameters = params;
    }

    public void doInitialize() throws ComponentInitializationException {
        if (this.storage == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
    }

    @Nullable
    public JWKSet fetch(@Nonnull URI uri, @Nonnull String keyId, @Nonnull Instant expires) {
        return this.fetch(CONTEXT_NAME, uri, keyId, expires);
    }

    @Nullable
    public JWKSet fetch(@Nonnull URI uri, @Nonnull Instant expires) {
        return this.fetch(CONTEXT_NAME, uri, expires);
    }

    @Nullable
    public JWKSet fetch(@Nonnull @NotEmpty String context, @Nonnull URI uri, @Nonnull Instant expires) {
        String key = uri.toString();
        assert (key != null);
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return null;
        }
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("JWK set '{}' was not in the cache, fetching it", (Object)key);
                return this.fetchAndStore(context, key, uri, expires);
            }
            JWKSet cachedSet = JWKSet.parse((String)entry.getValue());
            this.log.debug("Cached JWK set '{}' found and will be returned, expires at {}", (Object)key, (Object)entry.getExpiration());
            return cachedSet;
        }
        catch (IOException | ParseException e) {
            this.log.error("Exception reading/writing to storage service", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private JWKSet fetchAndStore(@Nonnull @NotEmpty String context, @Nonnull String cacheKey, @Nonnull URI uri, @Nonnull Instant expires) {
        try {
            JWKSet remoteJwkSet = RemoteJwkUtils.fetchRemoteJwkSet("RemoteJwkSetCache", uri, this.httpClient, this.httpClientSecurityParameters);
            if (remoteJwkSet != null && remoteJwkSet.getKeys() != null && !remoteJwkSet.getKeys().isEmpty()) {
                String value = remoteJwkSet.toString();
                assert (value != null);
                this.storage.create(context, cacheKey, value, Long.valueOf(expires.toEpochMilli()));
                return remoteJwkSet;
            }
            this.log.warn("Could not find any remote keys from {}", (Object)cacheKey);
            return null;
        }
        catch (IOException e) {
            this.log.error("Exception reading/writing to storage service", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public JWKSet fetch(@Nonnull @NotEmpty String context, @Nonnull URI uri, @Nonnull String keyId, @Nonnull Instant expires) {
        String key = uri.toString();
        assert (key != null);
        StorageCapabilities caps = this.storage.getCapabilities();
        if (context.length() > caps.getContextSize()) {
            this.log.error("context {} too long for StorageService (limit {})", (Object)context, (Object)caps.getContextSize());
            return null;
        }
        try {
            StorageRecord entry = this.storage.read(context, key);
            if (entry == null) {
                this.log.debug("JWK set '{}' was not in the cache, fetching it", (Object)key);
                return this.fetchAndStore(context, key, uri, expires);
            }
            JWKSet cachedSet = JWKSet.parse((String)entry.getValue());
            if (cachedSet.getKeyByKeyId(keyId) == null) {
                this.log.debug("Cached JWK set does not contain the keyId '{}', ignoring expiry and re-fetching", (Object)keyId);
                this.storage.delete(context, key);
                return this.fetchAndStore(context, key, uri, expires);
            }
            this.log.debug("Cached JWK set '{}' found and will be returned, expires at {}", (Object)key, (Object)entry.getExpiration());
            return cachedSet;
        }
        catch (IOException | ParseException e) {
            this.log.error("Exception reading/writing to storage service", (Throwable)e);
            return null;
        }
    }
}

