/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.oauth2.config.impl;

import com.nimbusds.oauth2.sdk.GrantType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.impl.AbstractOIDCSSOConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOAuth2TokenConfiguration
extends AbstractOIDCSSOConfiguration
implements OAuth2TokenConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oauth2.token";
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> grantTypesLookupStrategy = FunctionSupport.constant(Set.of(GrantType.AUTHORIZATION_CODE.toString(), GrantType.REFRESH_TOKEN.toString()));
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> refreshTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> enforceRefreshTokenRotationPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> issueIdTokenViaRefreshTokenPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private Predicate<ProfileRequestContext> limitInitialAccessTokenToSelfPredicate = PredicateSupport.alwaysFalse();

    public DefaultOAuth2TokenConfiguration() {
        this("http://shibboleth.net/ns/profiles/oauth2/token");
    }

    public DefaultOAuth2TokenConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getGrantTypes(@Nullable ProfileRequestContext profileRequestContext) {
        Collection types = this.grantTypesLookupStrategy.apply(profileRequestContext);
        if (types != null) {
            return CollectionSupport.copyToSet((Collection)types);
        }
        return CollectionSupport.emptySet();
    }

    public void setGrantTypes(@Nonnull @NonnullElements Collection<String> types) {
        Constraint.isNotNull(types, (String)"Collection of types cannot be null");
        this.grantTypesLookupStrategy = FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(types)));
    }

    public void setGrantTypesLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.grantTypesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> getRefreshTokenClaimsSetManipulationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.refreshTokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setRefreshTokenClaimsSetManipulationStrategy(@Nullable BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> strategy) {
        this.refreshTokenClaimsSetManipulationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setRefreshTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        this.refreshTokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isEnforceRefreshTokenRotation(@Nullable ProfileRequestContext profileRequestContext) {
        return this.enforceRefreshTokenRotationPredicate.test(profileRequestContext);
    }

    public void setEnforceRefreshTokenRotation(boolean flag) {
        this.enforceRefreshTokenRotationPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setEnforceRefreshTokenRotationPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.enforceRefreshTokenRotationPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isIssueIdTokenViaRefreshToken(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issueIdTokenViaRefreshTokenPredicate.test(profileRequestContext);
    }

    public void setIssueIdTokenViaRefreshToken(boolean flag) {
        this.issueIdTokenViaRefreshTokenPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setIssueIdTokenViaRefreshTokenPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.issueIdTokenViaRefreshTokenPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isLimitInitialAccessTokenToSelf(@Nullable ProfileRequestContext profileRequestContext) {
        return this.limitInitialAccessTokenToSelfPredicate.test(profileRequestContext);
    }

    public void setLimitInitialAccessTokenToSelf(boolean flag) {
        this.limitInitialAccessTokenToSelfPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setLimitInitialAccessTokenToSelfPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.limitInitialAccessTokenToSelfPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }
}

