/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.config.OIDCAuthorizationConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableClientProfileConfiguration;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.SignatureSigningParametersResolver;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.criterion.ClientSecretCredentialCriterion;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.oidc.security.jose.criterion.SignatureSigningConfigurationCriterion;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.slf4j.Logger;

public class PopulateJWTSignatureSigningParametersHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateJWTSignatureSigningParametersHandler.class);
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true);
    @Nullable
    private Function<MessageContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<MessageContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nonnull
    private Function<MessageContext, SAMLMetadataContext> metadataContextLookupStrategy;
    @Nonnull
    private Function<MessageContext, OIDCMetadataContext> oidcClientMetadataContextLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class);
    @Nonnull
    private Function<MessageContext, OIDCProviderMetadataContext> oidcProviderMetadataContextLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class);
    @Nonnull
    private Function<MessageContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;

    public PopulateJWTSignatureSigningParametersHandler() {
        Function rpcls = new ChildContextLookup(RelyingPartyContext.class).compose((Function)new RecursiveTypedParentContextLookup(ProfileRequestContext.class));
        assert (rpcls != null);
        this.relyingPartyContextLookupStrategy = rpcls;
        Function mcls = new ChildContextLookup(SAMLMetadataContext.class).compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class));
        assert (mcls != null);
        this.metadataContextLookupStrategy = mcls;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<MessageContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JWTSecurityParametersContext lookup strategy cannot be null");
    }

    public void setClientMetadataContextLookupStrategy(@Nonnull Function<MessageContext, OIDCMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcClientMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    public void setProviderMetadataContextLookupStrategy(@Nonnull Function<MessageContext, OIDCProviderMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcProviderMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCProviderMetadataContext lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (SignatureSigningParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureSigningParametersResolver cannot be null");
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<MessageContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<MessageContext, SAMLMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<MessageContext, List<SignatureSigningConfiguration>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            throw new ComponentInitializationException("ConfigurationLookupStrategy cannot be null");
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (super.doPreInvoke(messageContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        RelyingPartyContext rpCtx;
        OIDCProviderMetadata metadata;
        OIDCMetadataContext oidcMetadataCtx;
        OIDCClientInformation info;
        RoleDescriptor role;
        SecurityParametersContext existingCtx;
        this.log.debug("{} Resolving SignatureSigningParameters for request", (Object)this.getLogPrefix());
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(messageContext);
        if (paramsCtx == null) {
            this.log.debug("{} No JWTSecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No JWTSecurityParametersContext returned by lookup strategy");
        }
        if (this.existingParametersContextLookupStrategy != null && (existingCtx = this.existingParametersContextLookupStrategy.apply(messageContext)) != null && existingCtx.getSignatureSigningParameters() != null) {
            this.log.debug("{} Found existing JWTSecurityParametersContext to copy from", (Object)this.getLogPrefix());
            paramsCtx.setSignatureSigningParameters(existingCtx.getSignatureSigningParameters());
            return;
        }
        List<SignatureSigningConfiguration> configs = this.configurationLookupStrategy.apply(messageContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No SignatureSigningConfiguration returned by lookup strategy", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No SignatureSigningConfiguration returned by lookup strategy");
        }
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new SignatureSigningConfigurationCriterion(configs)});
        SAMLMetadataContext metadataCtx = this.metadataContextLookupStrategy.apply(messageContext);
        RoleDescriptor roleDescriptor = role = metadataCtx != null ? metadataCtx.getRoleDescriptor() : null;
        if (role != null) {
            this.log.debug("{} Adding metadata to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new RoleDescriptorCriterion(role));
        }
        OIDCClientInformation oIDCClientInformation = info = (oidcMetadataCtx = this.oidcClientMetadataContextLookupStrategy.apply(messageContext)) != null ? oidcMetadataCtx.getClientInformation() : null;
        if (info != null) {
            this.log.debug("{} Adding OIDC client information to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new ClientInformationCriterion(info));
        } else {
            this.log.debug("{} OIDCMetadataContext is absent", (Object)this.getLogPrefix());
        }
        OIDCProviderMetadataContext oidcProviderMetadataCtx = this.oidcProviderMetadataContextLookupStrategy.apply(messageContext);
        OIDCProviderMetadata oIDCProviderMetadata = metadata = oidcProviderMetadataCtx != null ? oidcProviderMetadataCtx.getProviderInformation() : null;
        if (metadata != null) {
            this.log.debug("{} Adding OIDC provider information to resolution criteria for signing/digest algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new ProviderMetadataCriterion(metadata));
        } else {
            this.log.debug("{} OIDCProviderMetadataContext is absent", (Object)this.getLogPrefix());
        }
        if (messageContext.getParent() instanceof ProfileRequestContext && (rpCtx = this.relyingPartyContextLookupStrategy.apply(messageContext)) != null && rpCtx.getConfiguration() != null && rpCtx.getProfileConfig() instanceof OIDCAuthorizationConfiguration) {
            OAuth2ClientAuthenticableClientProfileConfiguration profileConfiguration = (OAuth2ClientAuthenticableClientProfileConfiguration)rpCtx.getProfileConfig();
            if (profileConfiguration != null) {
                ClientSecretCredential credential = profileConfiguration.getClientCredential((ProfileRequestContext)messageContext.getParent());
                if (credential != null) {
                    criteria.add((Object)new ClientSecretCredentialCriterion(credential));
                } else {
                    this.log.trace("{} No credential found from the profile configuration", (Object)this.getLogPrefix());
                }
            } else {
                this.log.trace("{} Profile configuration not available, shared secret signing credential not present", (Object)this.getLogPrefix());
            }
        }
        try {
            SignatureSigningParameters params = (SignatureSigningParameters)this.resolver.resolveSingle((Object)criteria);
            if (params == null && this.noResultIsError) {
                this.log.error("Failed to resolve SignatureSigningParameters");
                throw new MessageHandlerException("Failed to resolve SignatureSigningParameters");
            }
            this.log.debug("{} {} SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
            paramsCtx.setSignatureSigningParameters(params);
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving SignatureSigningParameters", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Error resolving SignatureSigningParameters", (Exception)((Object)e));
        }
    }
}

