/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.impl.PopulateJWTSignatureSigningParametersHandler;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningParametersResolver;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.action.AbstractHandlerDelegatingProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class PopulateJWTSignatureSigningParameters
extends AbstractHandlerDelegatingProfileAction<PopulateJWTSignatureSigningParametersHandler> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateJWTSignatureSigningParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, SecurityParametersContext> existingParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<SignatureSigningConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcClientMetadataContextLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> oidcProviderMetadataContextLookupStrategy;
    @NonnullAfterInit
    private SignatureSigningParametersResolver resolver;
    private boolean noResultIsError;

    public PopulateJWTSignatureSigningParameters(@ParameterName(name="strategy") @Nonnull ContextDataLookupFunction<ProfileRequestContext, MessageContext> strategy) {
        super(PopulateJWTSignatureSigningParametersHandler.class, strategy);
        this.setErrorEvent("InvalidSecurityConfiguration");
        Function spcls = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (spcls != null);
        this.securityParametersContextLookupStrategy = spcls;
        this.noResultIsError = false;
    }

    public void setClientMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcClientMetadataContextLookupStrategy = strategy;
    }

    public void setProviderMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcProviderMetadataContextLookupStrategy = strategy;
    }

    public void setExistingParametersContextLookupStrategy(@Nullable Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.existingParametersContextLookupStrategy = strategy;
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<SignatureSigningConfiguration>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureSigningConfiguration lookup strategy cannot be null");
    }

    public void setSignatureSigningParametersResolver(@Nonnull SignatureSigningParametersResolver newResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (SignatureSigningParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureSigningParametersResolver cannot be null");
    }

    public void setNoResultIsError(boolean flag) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.noResultIsError = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null || this.configurationLookupStrategy == null) {
            throw new ComponentInitializationException("SignatureSigningParametersResolver and configuration lookup strategy cannot be null");
        }
        PopulateJWTSignatureSigningParametersHandler delegate = (PopulateJWTSignatureSigningParametersHandler)this.getDelegate();
        delegate.setNoResultIsError(this.noResultIsError);
        assert (this.resolver != null);
        delegate.setSignatureSigningParametersResolver(this.resolver);
        assert (this.configurationLookupStrategy != null);
        delegate.setConfigurationLookupStrategy(this.adaptRequired(this.configurationLookupStrategy));
        delegate.setSecurityParametersContextLookupStrategy(this.adaptRequired(this.securityParametersContextLookupStrategy));
        delegate.setExistingParametersContextLookupStrategy(this.adapt(this.existingParametersContextLookupStrategy));
        if (this.oidcClientMetadataContextLookupStrategy != null) {
            delegate.setClientMetadataContextLookupStrategy(this.adaptRequired(this.oidcClientMetadataContextLookupStrategy));
        }
        if (this.oidcProviderMetadataContextLookupStrategy != null) {
            delegate.setProviderMetadataContextLookupStrategy(this.adaptRequired(this.oidcProviderMetadataContextLookupStrategy));
        }
        delegate.initialize();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.log.debug("{} Signing enabled", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Signing not enabled", (Object)this.getLogPrefix());
        return false;
    }
}

