/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableClientProfileConfiguration;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.jose.DecryptionConfiguration;
import net.shibboleth.oidc.security.jose.DecryptionParameters;
import net.shibboleth.oidc.security.jose.DecryptionParametersResolver;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.oidc.security.jose.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.jose.criterion.ClientSecretCredentialCriterion;
import net.shibboleth.oidc.security.jose.criterion.DecryptionConfigurationCriterion;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class PopulateJWTDecryptionParameters
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateJWTDecryptionParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<DecryptionConfiguration>> configurationLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcClientMetadataContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @NonnullAfterInit
    private DecryptionParametersResolver resolver;

    public PopulateJWTDecryptionParameters() {
        Function spcls = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (spcls != null);
        this.securityParametersContextLookupStrategy = spcls;
        this.oidcClientMetadataContextLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setDecryptionParametersResolver(@Nonnull DecryptionParametersResolver newResolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.resolver = (DecryptionParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"DecryptionParametersResolver cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<DecryptionConfiguration>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DecryptionConfiguration lookup strategy cannot be null");
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setClientMetadataContextLookupStrategy(@Nullable Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.oidcClientMetadataContextLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("DecryptionParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            throw new ComponentInitializationException("DecryptionConfigurationLookup cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Resolving JWT DecryptionParameters for request", (Object)this.getLogPrefix());
        List<DecryptionConfiguration> configs = this.configurationLookupStrategy.apply(profileRequestContext);
        if (configs == null || configs.isEmpty()) {
            this.log.error("{} No DecryptionConfigurations returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return;
        }
        SecurityParametersContext paramsCtx = this.securityParametersContextLookupStrategy.apply(profileRequestContext);
        if (paramsCtx == null) {
            this.log.debug("{} No SecurityParametersContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            DecryptionParameters params = (DecryptionParameters)this.resolver.resolveSingle((Object)this.buildCriteriaSet(profileRequestContext, configs));
            paramsCtx.setDecryptionParameters(params);
            this.log.debug("{} {} DecryptionParameters", (Object)this.getLogPrefix(), (Object)(params != null ? "Resolved" : "Failed to resolve"));
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving DecryptionParameters", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
        }
    }

    @Nonnull
    private CriteriaSet buildCriteriaSet(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull List<DecryptionConfiguration> configs) {
        OIDCClientInformation info;
        CriteriaSet criteria = new CriteriaSet();
        criteria.add((Object)new DecryptionConfigurationCriterion(configs));
        OIDCMetadataContext oidcMetadataCtx = this.oidcClientMetadataContextLookupStrategy != null ? this.oidcClientMetadataContextLookupStrategy.apply(profileRequestContext) : null;
        OIDCClientInformation oIDCClientInformation = info = oidcMetadataCtx != null ? oidcMetadataCtx.getClientInformation() : null;
        if (info != null) {
            this.log.debug("{} Adding OIDC client information to resolution criteria for encryption algorithms", (Object)this.getLogPrefix());
            criteria.add((Object)new ClientInformationCriterion(info));
        } else {
            this.log.debug("{} No OIDC client information available", (Object)this.getLogPrefix());
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx != null && rpCtx.getConfiguration() != null && rpCtx.getProfileConfig() instanceof OAuth2ClientAuthenticableClientProfileConfiguration) {
            OAuth2ClientAuthenticableClientProfileConfiguration profileConfiguration = (OAuth2ClientAuthenticableClientProfileConfiguration)rpCtx.getProfileConfig();
            if (profileConfiguration != null) {
                ClientSecretCredential credential = profileConfiguration.getClientCredential(profileRequestContext);
                if (credential != null) {
                    criteria.add((Object)new ClientSecretCredentialCriterion(credential));
                } else {
                    this.log.trace("{} No credential found from the profile configuration", (Object)this.getLogPrefix());
                }
            } else {
                this.log.warn("{} Profile configuration not available, client credential missing", (Object)this.getLogPrefix());
            }
        }
        return criteria;
    }
}

