/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.impl;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.profile.config.JSONSecurityConfiguration;
import net.shibboleth.oidc.profile.messaging.JSONSuccessResponse;
import net.shibboleth.oidc.security.CredentialConversionUtil;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class FormOutboundKeySetResponseMessage
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FormOutboundKeySetResponseMessage.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<JSONSecurityConfiguration, List<Credential>> credentialsToPublishLookupStrategy = secConfig -> Collections.emptyList();
    @Nullable
    private JSONSecurityConfiguration secConfiguration;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setCredentialsToPublishLookupStrategy(@Nonnull Function<JSONSecurityConfiguration, List<Credential>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.credentialsToPublishLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"credentialsToPublishLookupStrategy can not be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        ProfileConfiguration profileConfig = rpCtx.getProfileConfig();
        if (profileConfig == null) {
            this.log.debug("{} No profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        SecurityConfiguration securityConfig = profileConfig.getSecurityConfiguration(profileRequestContext);
        if (!(securityConfig instanceof JSONSecurityConfiguration)) {
            this.log.debug("{} No security configuration associated with the profile configuration of the profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.secConfiguration = (JSONSecurityConfiguration)securityConfig;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ArrayList<JWK> publishList = new ArrayList<JWK>();
        List<Credential> credentialsToPublish = this.credentialsToPublishLookupStrategy.apply(this.secConfiguration);
        this.convertAndPublishToList(credentialsToPublish, publishList);
        JWKSet keySet = new JWKSet(publishList);
        JSONObject keySetJson = new JSONObject(keySet.toJSONObject());
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)new JSONSuccessResponse(keySetJson));
    }

    protected void convertAndPublishToList(List<Credential> credentials, List<JWK> publishList) {
        if (credentials != null) {
            for (Credential credential : credentials) {
                JWK jwk = CredentialConversionUtil.credentialToKey((Credential)credential);
                if (jwk == null) continue;
                publishList.add(jwk);
            }
        }
    }
}

