/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.encoding.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoding.impl.AbstractOIDCMessageEncoder;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2AuthorizationProfileConfiguration;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.slf4j.Logger;

public class HTTPRedirectAuthnRequestEncoder
extends AbstractOIDCMessageEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPRedirectAuthnRequestEncoder.class);

    public boolean test(@Nullable OAuth2AuthorizationProfileConfiguration.HttpRequestMethod requestMethod) {
        return OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.GET.equals((Object)requestMethod);
    }

    protected void doEncode() throws MessageEncodingException {
        this.log.debug("Encoding OIDC authentication request using Query String Serialization");
        MessageContext messageContext = this.getMessageContext();
        Object outboundMessage = messageContext.getMessage();
        if (!(outboundMessage instanceof OIDCAuthenticationRequest)) {
            throw new MessageEncodingException("No outbound OIDC authentication request message contained in message context");
        }
        String redirectURL = this.buildRedirectURL(messageContext, (OIDCAuthenticationRequest)outboundMessage);
        HttpServletResponse response = this.getHttpServletResponse();
        if (response == null) {
            throw new MessageEncodingException("No HttpServletResponse available.");
        }
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
        HttpServletSupport.setContentType((HttpServletResponse)response, (String)"application/x-www-form-urlencoded");
        try {
            this.log.trace("Redirecting user-agent to '{}'", (Object)redirectURL);
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect.", (Exception)e);
        }
    }

    protected String buildRedirectURL(MessageContext messageContext, OIDCAuthenticationRequest request) throws MessageEncodingException {
        if (request.getEndpointURI() == null) {
            throw new MessageEncodingException("No endpoint URI specified, URL can not be built.");
        }
        URLBuilder urlBuilder = null;
        try {
            if (request.getEndpointURI() == null) {
                throw new MessageEncodingException("Endpoint URL is null");
            }
            URI uri = request.getEndpointURI();
            if (uri == null) {
                throw new MessageEncodingException("No Endpoint URI available.");
            }
            String uriValue = uri.toString();
            assert (uriValue != null);
            urlBuilder = new URLBuilder(uriValue);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + String.valueOf(request.getEndpointURI()) + " is not a valid URL", (Exception)e);
        }
        this.serializeAuthorizationParamsToUrl(request, urlBuilder);
        return urlBuilder.buildURL();
    }
}

