/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.decoding.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.decoding.OIDCMessageDecoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.AbstractHttpServletRequestMessageDecoder;
import org.slf4j.Logger;

public class HTTPPostAuthnResponseDecoder
extends AbstractHttpServletRequestMessageDecoder
implements OIDCMessageDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPPostAuthnResponseDecoder.class);

    protected void doDecode() throws MessageDecodingException {
        this.log.trace("Decoding incomming 'form_post' authentication response");
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        assert (request != null);
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        try {
            AuthenticationResponse inboundMessage = AuthenticationResponseParser.parse((HTTPRequest)JakartaServletUtils.createHTTPRequest((HttpServletRequest)request));
            messageContext.setMessage((Object)inboundMessage);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to parse incomming authentication response", e);
        }
        this.setMessageContext(messageContext);
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return null;
    }
}

