/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.impl;

import java.time.Duration;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.profile.config.OIDCDynamicRegistrationConfiguration;
import net.shibboleth.oidc.profile.oauth2.config.impl.AbstractOAuth2FlowAwareProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class DefaultOIDCDynamicRegistrationConfiguration
extends AbstractOAuth2FlowAwareProfileConfiguration
implements OIDCDynamicRegistrationConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.oidc.register";
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Duration> registrationValidityPeriodLookupStrategy = FunctionSupport.constant((Object)Duration.ofHours(24L));
    @Nonnull
    private Function<ProfileRequestContext, Duration> secretExpirationPeriodLookupStrategy = FunctionSupport.constant((Object)Duration.ofDays(365L));
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> metadataPolicyLookupStrategy = FunctionSupport.constant(null);

    public DefaultOIDCDynamicRegistrationConfiguration() {
        this("http://shibboleth.net/ns/profiles/oidc/registration");
    }

    public DefaultOIDCDynamicRegistrationConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.registrationValidityPeriodLookupStrategy = FunctionSupport.constant(null);
    }

    @Nullable
    @NotEmpty
    public String getIssuer(@Nullable ProfileRequestContext profileRequestContext) {
        return this.issuerLookupStrategy.apply(profileRequestContext);
    }

    public void setIssuer(@Nullable @NotEmpty String issuer) {
        this.issuerLookupStrategy = FunctionSupport.constant((Object)issuer);
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getRegistrationValidityPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration period = this.registrationValidityPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        return period;
    }

    public void setRegistrationValidityPeriod(@Nullable @NonNegative Duration period) {
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        this.registrationValidityPeriodLookupStrategy = FunctionSupport.constant((Object)period);
    }

    public void setRegistrationValidityPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.registrationValidityPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    @NonNegative
    public Duration getSecretExpirationPeriod(@Nullable ProfileRequestContext profileRequestContext) {
        Duration period = this.secretExpirationPeriodLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        return period;
    }

    public void setSecretExpirationPeriod(@Nullable @NonNegative Duration period) {
        Constraint.isFalse((period != null && period.isNegative() ? 1 : 0) != 0, (String)"Validity period cannot be negative");
        this.secretExpirationPeriodLookupStrategy = FunctionSupport.constant((Object)period);
    }

    public void setSecretExpirationPeriodLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.secretExpirationPeriodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Map<String, MetadataPolicy> getMetadataPolicy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.metadataPolicyLookupStrategy.apply(profileRequestContext);
    }

    public void setMetadataPolicy(@Nonnull Map<String, MetadataPolicy> policy) {
        this.metadataPolicyLookupStrategy = FunctionSupport.constant(policy);
    }

    public void setMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        this.metadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

