/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.audit.impl;

import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.audit.impl.AbstractAuthenticationRequestAuditExtractor;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import org.opensaml.profile.context.ProfileRequestContext;

public class NonceAuditExtractor
extends AbstractAuthenticationRequestAuditExtractor<String> {
    public NonceAuditExtractor(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        OIDCAuthenticationRequest request = this.getRequestLookupStrategy().apply(input);
        if (request != null) {
            Nonce nonce = request.getNonce();
            return nonce != null ? nonce.getValue() : null;
        }
        return null;
    }
}

