/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.audit.impl;

import com.nimbusds.oauth2.sdk.id.Identifier;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.audit.impl.AbstractAuthenticationRequestAuditExtractor;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import org.opensaml.profile.context.ProfileRequestContext;

public class AuthenticationContextClassReferencesAuditExtractor
extends AbstractAuthenticationRequestAuditExtractor<List<String>> {
    public AuthenticationContextClassReferencesAuditExtractor(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable ProfileRequestContext input) {
        OIDCAuthenticationRequest request = this.getRequestLookupStrategy().apply(input);
        if (request != null && !request.getAcrs().isEmpty()) {
            return request.getAcrs().stream().filter(Objects::nonNull).map(Identifier::getValue).collect(Collectors.toList());
        }
        return null;
    }
}

