/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.attribute.transcoding.impl;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class OIDCStringAttributeTranscoder
extends AbstractOIDCAttributeTranscoder {
    @Nonnull
    @NotEmpty
    public static final String PROP_ASOBJECT = "oidc.asObject";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCStringAttributeTranscoder.class);

    @Nullable
    protected Object encodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        if (attribute.getValues().isEmpty()) {
            return null;
        }
        Stream<String> valuesStream = attribute.getValues().stream().filter(StringAttributeValue.class::isInstance).map(StringAttributeValue.class::cast).map(StringAttributeValue::getValue);
        if (valuesStream == null) {
            return null;
        }
        List<?> values = this.transformValues(rule, valuesStream);
        Boolean asObject = (Boolean)rule.getOrDefault(PROP_ASOBJECT, Boolean.class, (Object)false);
        assert (asObject != null);
        if (asObject.booleanValue()) {
            if (values.size() == 1) {
                Object value = values.get(0);
                if (!(value instanceof String)) {
                    throw new AttributeEncodingException("Value for IdPAttribute '" + attribute.getId() + "' is defined to be parsed as JSON, but is not String-typed");
                }
                return this.toJSONObject((String)value);
            }
            JSONArray array = new JSONArray();
            for (Object value : values) {
                if (!(value instanceof String)) {
                    this.log.warn("Value for IdPAttribute '{}' is defined to be parsed as JSON, but is not String-typed", (Object)attribute.getId());
                    continue;
                }
                try {
                    array.add(this.toJSONObject((String)value));
                }
                catch (AttributeEncodingException e) {
                    this.log.warn("IdPAttribute '{}'", (Object)attribute.getId(), (Object)e);
                }
            }
            return array;
        }
        Boolean asArray = (Boolean)rule.getOrDefault("oidc.asArray", Boolean.class, (Object)false);
        assert (asArray != null);
        if (asArray.booleanValue()) {
            JSONArray array = new JSONArray();
            array.addAll(values);
            return array;
        }
        String delimiter = (String)rule.getOrDefault("oidc.stringDelimiter", String.class, (Object)" ");
        boolean stringEmpty = true;
        StringBuilder attributeString = new StringBuilder();
        for (Object value : values) {
            if (value instanceof Integer || value instanceof Boolean) {
                if (values.size() > 1) {
                    this.log.warn("Values converted to Integer/Boolean but non-Array encoding, ignoring all but first");
                }
                return value;
            }
            if (value instanceof String) {
                if (!stringEmpty) {
                    attributeString.append(delimiter);
                } else {
                    stringEmpty = false;
                }
                attributeString.append(value);
                continue;
            }
            throw new AttributeEncodingException("Unrecognized value type: " + value.getClass().getName());
        }
        return attributeString.length() != 0 ? attributeString.toString() : null;
    }

    @Nonnull
    protected List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Object input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        if (input instanceof String) {
            return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)((String)input)));
        }
        Boolean numAsString = (Boolean)rule.getOrDefault("oidc.numberAsString", Boolean.class, (Object)false);
        assert (numAsString != null);
        Boolean boolAsString = (Boolean)rule.getOrDefault("oidc.booleanAsString", Boolean.class, (Object)false);
        assert (boolAsString != null);
        Boolean asObject = (Boolean)rule.getOrDefault(PROP_ASOBJECT, Boolean.class, (Object)false);
        assert (asObject != null);
        if (input instanceof Integer && numAsString.booleanValue()) {
            return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)Integer.toString((Integer)input)));
        }
        if (input instanceof Double && numAsString.booleanValue()) {
            return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)Double.toString((Double)input)));
        }
        if (input instanceof Boolean && boolAsString.booleanValue()) {
            return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)Boolean.toString((Boolean)input)));
        }
        if (input instanceof JSONArray) {
            Boolean arrayAsString = (Boolean)rule.getOrDefault("oidc.arrayAsString", Boolean.class, (Object)false);
            assert (arrayAsString != null);
            if (arrayAsString.booleanValue()) {
                return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)((JSONArray)input).toJSONString()));
            }
            JSONArray array = (JSONArray)input;
            ArrayList<IdPAttributeValue> arrayValuesDecoded = new ArrayList<IdPAttributeValue>();
            for (Object element : array) {
                assert (element != null);
                arrayValuesDecoded.addAll(this.decodeValues(profileRequestContext, element, rule));
            }
            return arrayValuesDecoded;
        }
        if (input instanceof JSONObject && asObject.booleanValue()) {
            return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)((JSONObject)input).toJSONString()));
        }
        if (input instanceof Map) {
            Map mapInput = (Map)input;
            if (asObject.booleanValue()) {
                HashMap mapWithStringKeys = new HashMap();
                for (Map.Entry entry : mapInput.entrySet()) {
                    if (!(entry.getKey() instanceof String)) continue;
                    mapWithStringKeys.put((String)entry.getKey(), entry.getValue());
                }
                return CollectionSupport.listOf((Object)StringAttributeValue.valueOf((String)new JSONObject(mapWithStringKeys).toJSONString()));
            }
        }
        this.log.trace("Could not convert values of type {} for the claim '{}' to a string attribute using transcoding rule '{} -> {}'", new Object[]{input.getClass().getName(), input, rule.getOrDefault("oidc.name", String.class, (Object)"unknown"), rule.getOrDefault("id", String.class, (Object)"unknown")});
        return CollectionSupport.emptyList();
    }

    @Nonnull
    private Object toJSONObject(@Nonnull @NotEmpty String value) throws AttributeEncodingException {
        try {
            Object parsedObject = new JSONParser(-1).parse(value);
            if (parsedObject != null) {
                return parsedObject;
            }
        }
        catch (ParseException e) {
            this.log.trace("Unable to parse string '{}' into JSONObject", (Object)value, (Object)e);
            throw new AttributeEncodingException("Unable to parse string into JSONObject", (Exception)((Object)e));
        }
        throw new AttributeEncodingException("Unable to parse string into JSONObject: parser returned null object");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    private List<?> transformValues(@Nonnull TranscodingRule rule, @Nonnull Stream<String> attributeValues) {
        Boolean asInt = (Boolean)rule.getOrDefault("oidc.asInteger", Boolean.class, (Object)false);
        assert (asInt != null);
        if (asInt.booleanValue()) {
            this.log.debug("String values interpreted as integer by rule");
            return (List)((NonnullSupplier)attributeValues.map(v -> {
                try {
                    return Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    this.log.debug("Value '{}' not a parseable integer", v);
                    return null;
                }
            }).filter((Predicate<Integer>)Predicates.notNull()).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
        }
        Boolean asBool = (Boolean)rule.getOrDefault("oidc.asBoolean", Boolean.class, (Object)false);
        assert (asBool != null);
        if (asBool.booleanValue()) {
            this.log.debug("String values interpreted as Boolean by rule");
            return (List)((NonnullSupplier)attributeValues.map(v -> XSBooleanValue.valueOf((String)v).getValue()).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
        }
        return (List)((NonnullSupplier)attributeValues.collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
    }
}

