/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.attribute.transcoding.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class OIDCScopedStringAttributeTranscoder
extends AbstractOIDCAttributeTranscoder {
    @Nonnull
    @NotEmpty
    public static final String PROP_SCOPE_DELIMITER = "oidc.scopeDelimiter";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCScopedStringAttributeTranscoder.class);

    @Nullable
    protected Object encodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        if (attribute.getValues().isEmpty()) {
            return null;
        }
        String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
        List values = attribute.getValues().stream().filter(ScopedStringAttributeValue.class::isInstance).map(ScopedStringAttributeValue.class::cast).map(v -> v.getValue() + scopeDelimiter + v.getScope()).collect(Collectors.toUnmodifiableList());
        Boolean asArray = (Boolean)rule.getOrDefault("oidc.asArray", Boolean.class, (Object)false);
        assert (asArray != null);
        if (asArray.booleanValue()) {
            JSONArray array = new JSONArray();
            array.addAll(values);
            return array;
        }
        String delimiter = (String)rule.getOrDefault("oidc.stringDelimiter", String.class, (Object)" ");
        boolean stringEmpty = true;
        StringBuilder attributeString = new StringBuilder();
        for (String value : values) {
            if (!stringEmpty) {
                attributeString.append(delimiter);
            } else {
                stringEmpty = false;
            }
            attributeString.append(value);
        }
        return attributeString.length() != 0 ? attributeString.toString() : null;
    }

    @Nonnull
    protected List<IdPAttributeValue> decodeValues(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Object input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        if (input instanceof String) {
            String stringValue = (String)input;
            String scopeDelimiter = (String)rule.getOrDefault(PROP_SCOPE_DELIMITER, String.class, (Object)"@");
            assert (scopeDelimiter != null);
            int offset = stringValue.indexOf(scopeDelimiter);
            if (offset < 0) {
                this.log.warn("Ignoring value '{}' with no scope delimiter ({})", (Object)stringValue, (Object)scopeDelimiter);
                return CollectionSupport.emptyList();
            }
            String scope = stringValue.substring(offset + scopeDelimiter.length());
            assert (scope != null);
            return CollectionSupport.listOf((Object)ScopedStringAttributeValue.valueOf((String)stringValue.substring(0, offset), (String)scope));
        }
        if (input instanceof JSONArray) {
            JSONArray array = (JSONArray)input;
            ArrayList<IdPAttributeValue> arrayValuesDecoded = new ArrayList<IdPAttributeValue>();
            for (Object element : array) {
                assert (element != null);
                arrayValuesDecoded.addAll(this.decodeValues(profileRequestContext, element, rule));
            }
            return arrayValuesDecoded;
        }
        this.log.trace("Could not convert values of type {} for the claim '{}' to a scoped string attribute using transcoding rule '{} -> {}'", new Object[]{input.getClass().getName(), input, rule.getOrDefault("oidc.name", String.class, (Object)"unknown"), rule.getOrDefault("id", String.class, (Object)"unknown")});
        return CollectionSupport.emptyList();
    }
}

