/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.CustomMetadataPolicyOperator;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultMetadataPolicyValidator
extends AbstractInitializableComponent
implements Predicate<Map<String, MetadataPolicy>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultMetadataPolicyValidator.class);
    @Nonnull
    private Map<String, CustomMetadataPolicyOperator> customOperators = CollectionSupport.emptyMap();

    public void setCustomMetadataPolicyOperators(@Nonnull Map<String, CustomMetadataPolicyOperator> operators) {
        this.checkSetterPreconditions();
        this.customOperators = (Map)Constraint.isNotNull(operators, (String)"Map of custom operators cannot be null");
    }

    @Override
    public boolean test(@Nullable Map<String, MetadataPolicy> map) {
        boolean result = true;
        if (map == null || map.isEmpty()) {
            return true;
        }
        for (String claim : map.keySet()) {
            MetadataPolicy policy = map.get(claim);
            List oneOfValues = policy.getOneOfValues();
            List subsetOfValues = policy.getSubsetOfValues();
            List supersetOfValues = policy.getSupersetOfValues();
            if ((subsetOfValues != null || supersetOfValues != null) && oneOfValues != null) {
                this.log.warn("Claim {}: one_of cannot be set when superset_of and/or subset_of is set", (Object)claim);
                result = false;
            }
            Object value = policy.getValue();
            Object add = policy.getAdd();
            Object defaultValue = policy.getDefaultValue();
            String regexp = policy.getRegexp();
            if (value != null && (add != null || defaultValue != null || oneOfValues != null || regexp != null || subsetOfValues != null || supersetOfValues != null)) {
                this.log.warn("Claim {}: value is set together with modifiers or value checks (other than essential)", (Object)claim);
                result = false;
            }
            if (supersetOfValues != null && subsetOfValues != null && !subsetOfValues.containsAll(supersetOfValues)) {
                this.log.warn("Claim {}: subset_of and superset_of set, but subset_of is not a superset of superset_of", (Object)claim);
                result = false;
            }
            if (!this.verifyValue(claim, (Pair<String, Object>)new Pair((Object)"add", add), subsetOfValues, supersetOfValues, oneOfValues)) {
                result = false;
            }
            if (!this.verifyValue(claim, (Pair<String, Object>)new Pair((Object)"default", defaultValue), subsetOfValues, supersetOfValues, oneOfValues)) {
                result = false;
            }
            if (policy.getCustomOperators().isEmpty()) continue;
            for (String operatorName : policy.getCustomOperators().keySet()) {
                CustomMetadataPolicyOperator customOperator = this.customOperators.get(operatorName);
                if (customOperator == null) {
                    this.log.warn("Claim {}: could not find a custom operator {}", (Object)claim, (Object)operatorName);
                    result = false;
                    continue;
                }
                if (customOperator.validate(policy)) continue;
                this.log.warn("Claimn {}: policy is not compatible with the custom operator {}", (Object)claim, (Object)operatorName);
                result = false;
            }
        }
        return result;
    }

    protected boolean verifyValue(String claim, Pair<String, Object> value, List<Object> subsetOfValues, List<Object> supersetOfValues, List<Object> oneOfValues) {
        boolean result = true;
        String valueId = (String)value.getFirst();
        Object valueObject = value.getSecond();
        if (valueObject != null) {
            if (subsetOfValues != null && !MetadataPolicyHelper.isSubsetOfValues(valueObject, subsetOfValues)) {
                this.log.warn("Claim {}: {} contains values that are not subset of values in subset_of", (Object)claim, (Object)valueId);
                result = false;
            }
            if (supersetOfValues != null && !MetadataPolicyHelper.isSupersetOfValues(valueObject, supersetOfValues)) {
                this.log.warn("Claim {}: {} contains values that are not superset of values in superset_of", (Object)claim, (Object)valueId);
                result = false;
            }
            if (oneOfValues != null && !oneOfValues.contains(valueObject)) {
                this.log.warn("Claim {}: {} contains value that is not included in one_of", (Object)claim, (Object)valueId);
                result = false;
            }
        }
        return result;
    }
}

