/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.keyinfo.ext.impl.provider;

import com.nimbusds.oauth2.sdk.auth.Secret;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.saml.xmlobject.ClientSecret;
import net.shibboleth.oidc.security.credential.BasicNimbusSecretCredential;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.slf4j.Logger;

public class ClientSecretProvider
extends AbstractKeyInfoProvider {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientSecretProvider.class);

    @Nullable
    public Collection<Credential> process(@Nonnull KeyInfoCredentialResolver resolver, @Nonnull XMLObject keyInfoChild, @Nullable CriteriaSet criteriaSet, @Nonnull KeyInfoResolutionContext kiContext) throws SecurityException {
        ClientSecret clientSecret = this.getClientSecret(keyInfoChild);
        if (clientSecret == null || StringSupport.trimOrNull((String)clientSecret.getValue()) == null) {
            this.log.debug("No value found for the ClientSecret element");
            return null;
        }
        LazySet credentials = new LazySet();
        credentials.add((Object)new BasicNimbusSecretCredential(new Secret(clientSecret.getValue())));
        return credentials;
    }

    public boolean handles(@Nonnull XMLObject keyInfoChild) {
        return this.getClientSecret(keyInfoChild) != null;
    }

    @Nullable
    protected ClientSecret getClientSecret(@Nonnull XMLObject xmlObject) {
        if (xmlObject instanceof ClientSecret) {
            return (ClientSecret)xmlObject;
        }
        return null;
    }
}

