/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.criterion.ClientSecretReferenceCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractClientSecretValueResolver;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

public class PropertiesClientSecretValueResolver
extends AbstractClientSecretValueResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PropertiesClientSecretValueResolver.class);
    @NonnullAfterInit
    private Resource propertiesResource;

    public void setResource(@Nonnull Resource resource) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.propertiesResource = (Resource)Constraint.isNotNull((Object)resource, (String)"Properties resource cannot be null");
        Properties properties = new Properties();
        try {
            properties.load(this.propertiesResource.getInputStream());
        }
        catch (IOException e) {
            this.log.error("Could not read the properties from the given resource", (Throwable)e);
            throw new ConstraintViolationException("The properties resource must be readable");
        }
    }

    @NonnullAfterInit
    public Resource getResource() {
        return this.propertiesResource;
    }

    @Nonnull
    public Iterable<String> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        String value = this.resolveSingle(criteria);
        if (value != null) {
            return CollectionSupport.singletonList((Object)value);
        }
        return CollectionSupport.emptySet();
    }

    @Nullable
    public String resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        ClientSecretReferenceCriterion criterion;
        this.ifNotInitializedThrowUninitializedComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        ClientSecretReferenceCriterion clientSecretReferenceCriterion = criterion = criteria != null ? (ClientSecretReferenceCriterion)criteria.get(ClientSecretReferenceCriterion.class) : null;
        if (criterion == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(this.propertiesResource.getInputStream());
        }
        catch (IOException e) {
            this.log.error("Could not read the properties from the resource", (Throwable)e);
            throw new ResolverException((Exception)e);
        }
        return properties.getProperty(criterion.getSecretReference());
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getResource() == null) {
            throw new ComponentInitializationException("Properties resource cannot be null");
        }
    }

    protected void doDestroy() {
        this.propertiesResource = null;
        super.doDestroy();
    }
}

