/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;
import org.slf4j.MDC;

public abstract class AbstractDynamicHTTPFetchingStrategy<MetadataType>
extends AbstractIdentifiableInitializableComponent
implements Function<CriteriaSet, MetadataType> {
    public static final String MDC_ATTRIB_CURRENT_REQUEST_URI = AbstractDynamicHTTPFetchingStrategy.class.getName() + ".currentRequestURI";
    private static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/json", "application/samlmetadata+xml", "application/xml", "text/xml"};
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicHTTPFetchingStrategy.class);
    @Nonnull
    private final HttpClient httpClient;
    @NonnullAfterInit
    private List<String> supportedContentTypes;
    @NonnullAfterInit
    private String supportedContentTypesValue;
    @NonnullAfterInit
    private Set<MediaType> supportedMediaTypes;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @Nonnull
    private final HttpClientResponseHandler<MetadataType> responseHandler;

    protected AbstractDynamicHTTPFetchingStrategy(@Nonnull HttpClient client, @Nonnull HttpClientResponseHandler<MetadataType> handler) {
        this.responseHandler = (HttpClientResponseHandler)Constraint.isNotNull(handler, (String)"Response handler can not be null");
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP Client can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        List<String> localSupportedContentTypes = this.getSupportedContentTypes();
        assert (localSupportedContentTypes != null);
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(localSupportedContentTypes, (String)", ");
            this.supportedMediaTypes = new LazySet();
            for (String contentType : this.getSupportedContentTypes()) {
                this.supportedMediaTypes.add(MediaType.parse((String)contentType));
            }
        } else {
            this.supportedMediaTypes = Collections.emptySet();
        }
        this.log.debug("{} Supported content types are: {}", (Object)this.getId(), this.getSupportedContentTypes());
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClientSecurityParameters = params;
    }

    @NonnullAfterInit
    @NotLive
    @Unmodifiable
    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(@Nullable List<String> types) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.supportedContentTypes = types == null ? Collections.emptyList() : StringSupport.normalizeStringCollection(types).stream().filter(s -> s != null).map(String::toLowerCase).collect(Collectors.toUnmodifiableList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MetadataType apply(@Nullable CriteriaSet criteria) {
        this.log.debug("{} fetching metadata based on criteria: {}", (Object)this.getId(), (Object)criteria);
        ClassicHttpRequest request = this.buildHttpRequest(criteria);
        if (request == null) {
            this.log.debug("Could not build request based on input criteria, unable to query");
            return null;
        }
        HttpClientContext context = this.buildHttpClientContext(request);
        try {
            MDC.put((String)MDC_ATTRIB_CURRENT_REQUEST_URI, (String)request.getUri().toString());
            Object result = this.httpClient.execute(request, (HttpContext)context, this.responseHandler);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)context, (String)request.getUri().getScheme());
            Object object = result;
            return (MetadataType)object;
        }
        catch (IOException | IllegalArgumentException | URISyntaxException e) {
            this.log.warn("Unable to fetch metadata from remote HTTP source", (Throwable)e);
            MetadataType MetadataType = null;
            return MetadataType;
        }
        finally {
            MDC.remove((String)MDC_ATTRIB_CURRENT_REQUEST_URI);
        }
    }

    @Nonnull
    private HttpClientContext buildHttpClientContext(@Nonnull ClassicHttpRequest request) {
        HttpClientContext context = HttpClientContext.create();
        assert (context != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)context, (HttpRequest)request);
        return context;
    }

    @Nullable
    private ClassicHttpRequest buildHttpRequest(@Nullable CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("Built request URL of: {}", (Object)url);
        if (url == null) {
            this.log.debug("Could not construct request URL from input criteria, unable to query");
            return null;
        }
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty((String)this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", (Object)this.supportedContentTypesValue);
        }
        return getMethod;
    }

    @Nullable
    protected abstract String buildRequestURL(@Nullable CriteriaSet var1);
}

