/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.profile.config.navigate.UseTargetedEndpointAsJWTAudienceLookupFunction;
import net.shibboleth.oidc.security.jwt.claims.impl.AudienceClaimsValidator;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafeAfterInit
public class JWTAuthenticationAudienceClaimsValidator
extends AudienceClaimsValidator {
    @Nonnull
    private Function<ProfileRequestContext, String> responderIdLookupStrategy = new IssuerLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> allowTargetedEndpointAsJWTAudienceCondition = new UseTargetedEndpointAsJWTAudienceLookupFunction();
    @Nonnull
    private List<String> endpointTargets = CollectionSupport.emptyList();
    @Nullable
    private String endpointReplacement = null;

    public void setResponderIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.responderIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The responder ID lookup strategy cannot be null");
    }

    public void setAllowTargetedEndpointAsJWTAudienceCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.allowTargetedEndpointAsJWTAudienceCondition = (Predicate)Constraint.isNotNull(condition, (String)"The allow targeted endpoint condition cannot be null");
    }

    public void setEndpointTargets(@Nonnull List<String> paths) {
        this.checkSetterPreconditions();
        this.endpointTargets = (List)Constraint.isNotNull(paths, (String)"The endpoint paths to replace cannot be null");
    }

    public void setEndpointReplacement(@Nullable String path) {
        this.checkSetterPreconditions();
        this.endpointReplacement = path;
    }

    @Override
    @Nonnull
    @NotEmpty
    protected Set<String> resolveAcceptedAudiences(@Nonnull JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        HashSet<String> result = new HashSet<String>();
        String responderId = this.responderIdLookupStrategy.apply(context);
        if (StringSupport.trimOrNull((String)responderId) != null) {
            result.add(responderId);
        }
        if (this.allowTargetedEndpointAsJWTAudienceCondition.test(context)) {
            String endpointAudience = super.resolveAcceptedAudiences(claims, context).iterator().next();
            result.add(endpointAudience);
            for (String path : this.endpointTargets) {
                if (!endpointAudience.contains(path) || this.endpointReplacement == null) continue;
                result.add(endpointAudience.replace(path, this.endpointReplacement));
            }
        }
        if (result.isEmpty()) {
            throw new JWTValidationException("Could not resolve any accepted audiences");
        }
        return CollectionSupport.copyToSet(result);
    }
}

