/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public final class AuthTimeRequestedActivationCondition
implements BiPredicate<ProfileRequestContext, JWTClaimsSet> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthTimeRequestedActivationCondition.class);
    @Nonnull
    private final Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy;

    public AuthTimeRequestedActivationCondition(@ParameterName(name="authenticationRequestLookupStrategy") @Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"authenticationRequestLookupStrategy can not be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext prc, @Nullable JWTClaimsSet claims) {
        OIDCAuthenticationRequest authRequest = this.authenticationRequestLookupStrategy.apply(prc);
        if (authRequest == null) {
            this.log.warn("Authentication request not found in profile context, is the authenticationRequestLookupStrategy configured correctly? The 'auth_time' is now active");
            return true;
        }
        if (authRequest.getMaxAge() != null) {
            return true;
        }
        OIDCClaimsRequest requestedClaims = authRequest.getRequestedClaims();
        if (requestedClaims != null) {
            ClaimsSetRequest idTokenRequested = requestedClaims.getIDTokenClaimsRequest();
            if (idTokenRequested == null) {
                return false;
            }
            ClaimsSetRequest.Entry authTime = idTokenRequested.get("auth_time");
            if (authTime != null) {
                if (authTime.getClaimRequirement() == ClaimRequirement.ESSENTIAL) {
                    return true;
                }
                if (authTime.getClaimRequirement() == ClaimRequirement.VOLUNTARY) {
                    return claims != null && claims.getClaim("auth_time") != null;
                }
            }
        }
        return false;
    }
}

