/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.jose.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.criterion.ClientSecretCredentialCriterion;
import net.shibboleth.oidc.security.jose.criterion.ProviderMetadataCriterion;
import net.shibboleth.oidc.security.jose.impl.BasicSignatureSigningParametersResolver;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class RelyingPartySigningParametersResolver
extends BasicSignatureSigningParametersResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RelyingPartySigningParametersResolver.class);
    @Nonnull
    private Function<OIDCProviderMetadata, List<String>> providerMetadataAlgorithmLookupStrategy = FunctionSupport.constant(null);

    public void setProviderMetadataAlgorithmLookupStrategy(@Nonnull Function<OIDCProviderMetadata, List<String>> strategy) {
        this.providerMetadataAlgorithmLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProviderMetadataAlgorithmLookupStrategy can not be null");
    }

    @Override
    protected void resolveAndPopulateCredentialAndSignatureAlgorithm(@Nonnull SignatureSigningParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> includeExcludePredicate) {
        ArrayList<Credential> allCredentials = new ArrayList<Credential>();
        ClientSecretCredentialCriterion secretCrit = (ClientSecretCredentialCriterion)criteria.get(ClientSecretCredentialCriterion.class);
        if (secretCrit != null) {
            ClientSecretCredential staticCred = secretCrit.getCredential();
            this.log.trace("Client secret signing credential found in criterion");
            allCredentials.add((Credential)staticCred.toSigningCredential());
        }
        allCredentials.addAll(this.getEffectiveSigningCredentials(criteria));
        List<String> algorithms = this.getEffectiveSignatureAlgorithms(criteria, includeExcludePredicate);
        this.log.debug("Resolved effective signature algorithms from config: '{}'", algorithms);
        List<String> supportedAlgorithms = this.filterForProviderSupportedAlgorithms(criteria, algorithms);
        this.log.trace("Resolved effective signature algorithms: {}", supportedAlgorithms);
        this.findCompatibleAlgorithmAndCredential(supportedAlgorithms, allCredentials, params);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    private List<String> filterForProviderSupportedAlgorithms(@Nonnull CriteriaSet criteria, @Nonnull List<String> algorithms) {
        ProviderMetadataCriterion pmCrit = (ProviderMetadataCriterion)criteria.get(ProviderMetadataCriterion.class);
        if (pmCrit != null) {
            List<String> opSupportedAlgNames = this.providerMetadataAlgorithmLookupStrategy.apply(pmCrit.getMetadata());
            this.log.trace("Provider metadata supports the following signature algorithms '{}'", opSupportedAlgNames);
            if (opSupportedAlgNames == null) {
                this.log.trace("Lookup strategy could not determine provider supported algorithms from metadata, no further filtering performed");
                return CollectionSupport.copyToList(algorithms);
            }
            return (List)((NonnullSupplier)algorithms.stream().filter(opSupportedAlgNames::contains).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
        }
        this.log.debug("No provider metadata criterion, unable to filter for provider supported algorithms");
        return CollectionSupport.copyToList(algorithms);
    }
}

