/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.jose.criterion.KeyIdCriterion;
import net.shibboleth.shared.logic.AbstractTriStatePredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.slf4j.Logger;

public class EvaluableKeyIDCredentialCriterion
extends AbstractTriStatePredicate<Credential>
implements EvaluableCredentialCriterion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EvaluableKeyIDCredentialCriterion.class);
    @Nonnull
    private final String keyId;

    public EvaluableKeyIDCredentialCriterion(@Nonnull KeyIdCriterion criteria) {
        this.keyId = ((KeyIdCriterion)Constraint.isNotNull((Object)criteria, (String)"Criterion instance cannot be null")).getKeyId();
    }

    public EvaluableKeyIDCredentialCriterion(@Nonnull String newKeyId) {
        String trimmed = StringSupport.trimOrNull((String)newKeyId);
        this.keyId = (String)Constraint.isNotNull((Object)trimmed, (String)"Key id cannot be null or empty");
    }

    @Nonnull
    public String getKeyId() {
        return this.keyId;
    }

    public boolean test(@Nullable Credential target) {
        JWKCredential downcast;
        if (target == null) {
            this.log.error("Credential target was null");
            return this.isNullInputSatisfies();
        }
        if (!(target instanceof JWKCredential)) {
            this.log.info("Could not evaluate criteria, credential was not a JWK");
            return this.isUnevaluableSatisfies();
        }
        JWKCredential jwk = downcast = (JWKCredential)target;
        String kid = jwk.getKid();
        if (Strings.isNullOrEmpty((String)kid)) {
            this.log.info("Could not evaluate criteria, credential contained no key ID");
            return this.isUnevaluableSatisfies();
        }
        return this.keyId.equals(kid);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EvaluableKeyIDCredentialCriterion [keyId =");
        builder.append(this.keyId);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.keyId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EvaluableKeyIDCredentialCriterion) {
            EvaluableKeyIDCredentialCriterion c = (EvaluableKeyIDCredentialCriterion)((Object)obj);
            return this.keyId.equals(c.keyId);
        }
        return false;
    }
}

