/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class DataEncryptionAlgorithmCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private String encAlgorithm;

    public DataEncryptionAlgorithmCriterion(@Nonnull String algorithm) {
        String trimmed = StringSupport.trimOrNull((String)algorithm);
        this.encAlgorithm = (String)Constraint.isNotNull((Object)trimmed, (String)"Encryption algorithm criteria cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public void setEncAlgorithm(@Nonnull String algorithm) {
        String trimmed = StringSupport.trimOrNull((String)algorithm);
        this.encAlgorithm = (String)Constraint.isNotNull((Object)trimmed, (String)"Encryption algorithm criteria cannot be null or empty");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DataEncryptionAlgorithmCriterion [encAlgorithm=");
        builder.append(this.encAlgorithm);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.encAlgorithm.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DataEncryptionAlgorithmCriterion) {
            DataEncryptionAlgorithmCriterion c = (DataEncryptionAlgorithmCriterion)obj;
            return this.encAlgorithm.equals(c.encAlgorithm);
        }
        return false;
    }
}

