/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.security.credential.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.credential.impl.BasicJOSEObjectCredentialResolver;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;

public class CollectionJOSEObjectCredentialResolver
extends BasicJOSEObjectCredentialResolver {
    @Nonnull
    @NonnullElements
    private final List<Credential> collection;

    public CollectionJOSEObjectCredentialResolver(@Nonnull @ParameterName(name="credentials") List<Credential> credentials) {
        Constraint.isNotNull(credentials, (String)"Input credentials list cannot be null");
        this.collection = (List)((NonnullSupplier)credentials.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toList()))).get();
    }

    public CollectionJOSEObjectCredentialResolver(@Nonnull @ParameterName(name="credential") Credential credential) {
        Constraint.isNotNull((Object)credential, (String)"Input credential cannot be null");
        this.collection = new ArrayList<Credential>();
        this.collection.add(credential);
    }

    @Override
    @Nonnull
    @NonnullElements
    public Iterable<Credential> resolveFromSource(@Nullable CriteriaSet criteria) throws ResolverException {
        return this.collection;
    }
}

