/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2ClientAuthenticableProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class TokenEndpointAuthMethodLookupFunction
extends AbstractRelyingPartyLookupFunction<Set<ClientAuthenticationMethod>> {
    @Nullable
    public Set<ClientAuthenticationMethod> apply(@Nullable ProfileRequestContext input) {
        ProfileConfiguration pc;
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof OAuth2ClientAuthenticableProfileConfiguration) {
            Set<String> methods = ((OAuth2ClientAuthenticableProfileConfiguration)pc).getTokenEndpointAuthMethods(input);
            return methods.stream().map(ClientAuthenticationMethod::new).collect(Collectors.toUnmodifiableSet());
        }
        return null;
    }
}

