/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.MetadataPolicyResolver;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ResolverBasedRegistrationMetadataPolicyLookupFunction
extends AbstractRelyingPartyLookupFunction<Map<String, MetadataPolicy>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ResolverBasedRegistrationMetadataPolicyLookupFunction.class);
    @Nullable
    private MetadataPolicyResolver metadataPolicyResolver;
    @Nullable
    private Function<ProfileRequestContext, CriteriaSet> criteriaSetLookupStrategy;

    public void setMetadataPolicyResolver(@Nullable MetadataPolicyResolver resolver) {
        this.metadataPolicyResolver = resolver;
    }

    public void setCriteriaSetLookupStrategy(@Nullable Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.criteriaSetLookupStrategy = strategy;
    }

    @Nullable
    public Map<String, MetadataPolicy> apply(@Nullable ProfileRequestContext input) {
        if (this.metadataPolicyResolver == null) {
            this.log.debug("No metadata policy resolver configured, returning null");
            return null;
        }
        CriteriaSet criteriaSet = this.criteriaSetLookupStrategy != null ? this.criteriaSetLookupStrategy.apply(input) : null;
        this.log.debug("Starting to resolve single metadata policy");
        try {
            assert (this.metadataPolicyResolver != null);
            return (Map)this.metadataPolicyResolver.resolveSingle((Object)(criteriaSet == null ? new CriteriaSet() : criteriaSet));
        }
        catch (ResolverException e) {
            this.log.error("Resolver exception catched while resolving metadata policy", (Throwable)e);
            return null;
        }
    }
}

