/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public class ProxyAwareDefaultOIDCAuthenticationContextClassResponseLookupFunction
implements Function<Collection<String>, Collection<Principal>> {
    @Nonnull
    @NonnullElements
    private final Map<String, Collection<Principal>> principalMappings;

    public ProxyAwareDefaultOIDCAuthenticationContextClassResponseLookupFunction(@Nullable @ParameterName(name="mappings") @NonnullElements Map<String, Collection<Principal>> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.principalMappings = CollectionSupport.emptyMap();
        } else {
            this.principalMappings = new HashMap<String, Collection<Principal>>(mappings.size());
            mappings.forEach((k, v) -> this.principalMappings.put((String)k, List.copyOf(v)));
        }
    }

    @Override
    @Nullable
    public Collection<Principal> apply(Collection<String> amrOrAcrs) {
        if (amrOrAcrs != null) {
            ArrayList<Principal> principals = new ArrayList<Principal>();
            for (String amrOrAcr : amrOrAcrs) {
                Collection<Principal> mappedPrincipals;
                if (!this.principalMappings.containsKey(amrOrAcr) || (mappedPrincipals = this.principalMappings.get(amrOrAcr)).isEmpty()) continue;
                principals.addAll(mappedPrincipals);
            }
            return principals;
        }
        return CollectionSupport.emptyList();
    }

    public static class LookupFunctionWrapper
    implements Function<ProfileRequestContext, Function<Collection<String>, Collection<Principal>>> {
        @Nonnull
        private final Function<Collection<String>, Collection<Principal>> function;

        public LookupFunctionWrapper(@ParameterName(name="wrappedFunction") Function<Collection<String>, Collection<Principal>> wrappedFunction) {
            this.function = (Function)Constraint.isNotNull(wrappedFunction, (String)"Lookup function can not be null");
        }

        @Override
        @Nullable
        public Function<Collection<String>, Collection<Principal>> apply(@Nullable ProfileRequestContext prc) {
            return this.function;
        }
    }
}

