/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.config.navigate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.JSONSecurityConfiguration;
import net.shibboleth.oidc.security.credential.JOSEObjectCredentialResolver;
import net.shibboleth.oidc.security.jose.DecryptionConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;

public class JWKCredentialsToPublishLookupStrategy
implements Function<JSONSecurityConfiguration, List<Credential>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWKCredentialsToPublishLookupStrategy.class);

    @Override
    @Nullable
    public List<Credential> apply(@Nullable JSONSecurityConfiguration config) {
        DecryptionConfiguration decryptConfig;
        if (config == null) {
            return Collections.emptyList();
        }
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        SignatureSigningConfiguration signingConfig = config.getJwtSignatureSigningConfiguration();
        if (signingConfig != null) {
            credentials.addAll(signingConfig.getSigningCredentials());
        }
        if ((decryptConfig = config.getJwtDecryptionConfiguration()) != null) {
            try {
                JOSEObjectCredentialResolver resolver = decryptConfig.getKEKCredentialResolver();
                if (resolver != null) {
                    Iterable resolvedCreds = resolver.resolve((Object)new CriteriaSet());
                    resolvedCreds.forEach(credentials::add);
                }
            }
            catch (ResolverException e) {
                this.log.debug("Unable to resolve decryption credentials", (Throwable)e);
            }
        }
        return credentials;
    }
}

